/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import sop.external.AbstractExternalSOPTest;
import sop.external.JUtils;

@EnabledIf(value="sop.external.AbstractExternalSOPTest#isExternalSopInstalled")
public class ExternalGenerateKeyTest
extends AbstractExternalSOPTest {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String BEGIN_PGP_PRIVATE_KEY_BLOCK = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n";
    byte[] BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n".getBytes(UTF8);

    @Test
    public void generateKeyTest() throws IOException {
        byte[] key = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").generate().getBytes();
        JUtils.assertArrayStartsWith(key, this.BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES);
    }

    @Test
    public void generateKeyNoArmor() throws IOException {
        byte[] key = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").noArmor().generate().getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(key, this.BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES));
    }

    @Test
    public void generateKeyWithMultipleUserIdsTest() throws IOException {
        byte[] key = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").userId("Bob <bob@openpgp.org>").generate().getBytes();
        JUtils.assertArrayStartsWith(key, this.BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES);
    }

    @Test
    public void generateKeyWithoutUserIdTest() throws IOException {
        this.ignoreIf("pgpainless-cli", AbstractExternalSOPTest.Is.le, "1.3.15");
        byte[] key = this.getSop().generateKey().generate().getBytes();
        JUtils.assertArrayStartsWith(key, this.BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES);
    }

    @Test
    public void generateKeyWithPasswordTest() throws IOException {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.le, "0.27.0");
        this.ignoreIf("pgpainless-cli", AbstractExternalSOPTest.Is.le, "1.3.0");
        byte[] key = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").withKeyPassword("sw0rdf1sh").generate().getBytes();
        JUtils.assertArrayStartsWith(key, this.BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES);
    }

    @Test
    public void generateKeyWithMultipleUserIdsAndPassword() throws IOException {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.le, "0.27.0");
        this.ignoreIf("PGPainless-SOP", AbstractExternalSOPTest.Is.le, "1.3.15");
        this.ignoreIf("PGPainless-SOP", AbstractExternalSOPTest.Is.eq, "1.4.0");
        this.ignoreIf("PGPainless-SOP", AbstractExternalSOPTest.Is.eq, "1.4.1");
        byte[] key = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").userId("Bob <bob@openpgp.org>").withKeyPassword("sw0rdf1sh").generate().getBytes();
        JUtils.assertArrayStartsWith(key, this.BEGIN_PGP_PRIVATE_KEY_BLOCK_BYTES);
    }
}

