/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import sop.ByteArrayAndResult;
import sop.enums.InlineSignAs;
import sop.exception.SOPGPException;
import sop.external.AbstractExternalSOPTest;
import sop.external.JUtils;
import sop.operation.InlineSign;
import sop.operation.InlineVerify;
import sop.util.UTCUtil;

@EnabledIf(value="sop.external.AbstractExternalSOPTest#isExternalSopInstalled")
public class ExternalInlineSignVerifyTest
extends AbstractExternalSOPTest {
    private static final String BEGIN_PGP_MESSAGE = "-----BEGIN PGP MESSAGE-----\n";
    private static final byte[] BEGIN_PGP_MESSAGE_BYTES = "-----BEGIN PGP MESSAGE-----\n".getBytes(StandardCharsets.UTF_8);
    private static final String BEGIN_PGP_SIGNED_MESSAGE = "-----BEGIN PGP SIGNED MESSAGE-----\n";
    private static final byte[] BEGIN_PGP_SIGNED_MESSAGE_BYTES = "-----BEGIN PGP SIGNED MESSAGE-----\n".getBytes(StandardCharsets.UTF_8);

    @Test
    public void inlineSignVerifyAlice() throws IOException {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.26.1");
        byte[] message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)this.getSop().inlineSign().key("-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxVgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RzSZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPsKQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICx10EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK7CeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=3GfK\n-----END PGP PRIVATE KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(message).getBytes();
        JUtils.assertArrayStartsWith(inlineSigned, BEGIN_PGP_MESSAGE_BYTES);
        ByteArrayAndResult bytesAndResult = ((InlineVerify)this.getSop().inlineVerify().cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(inlineSigned).toByteArrayAndResult();
        Assertions.assertArrayEquals((byte[])message, (byte[])bytesAndResult.getBytes());
        Assertions.assertFalse((boolean)((List)bytesAndResult.getResult()).isEmpty());
    }

    @Test
    public void inlineSignVerifyAliceNoArmor() throws IOException {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.26.1");
        byte[] message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)((InlineSign)this.getSop().inlineSign().key("-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxVgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RzSZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPsKQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICx10EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK7CeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=3GfK\n-----END PGP PRIVATE KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).noArmor()).data(message).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(inlineSigned, BEGIN_PGP_MESSAGE_BYTES));
        ByteArrayAndResult bytesAndResult = ((InlineVerify)this.getSop().inlineVerify().cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(inlineSigned).toByteArrayAndResult();
        Assertions.assertArrayEquals((byte[])message, (byte[])bytesAndResult.getBytes());
        Assertions.assertFalse((boolean)((List)bytesAndResult.getResult()).isEmpty());
    }

    @Test
    public void clearsignVerifyAlice() throws IOException {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.26.1");
        byte[] message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] clearsigned = ((InlineSign)this.getSop().inlineSign().key("-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxVgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RzSZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPsKQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICx10EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK7CeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=3GfK\n-----END PGP PRIVATE KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).mode(InlineSignAs.clearsigned).data(message).getBytes();
        JUtils.assertArrayStartsWith(clearsigned, BEGIN_PGP_SIGNED_MESSAGE_BYTES);
        ByteArrayAndResult bytesAndResult = ((InlineVerify)this.getSop().inlineVerify().cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(clearsigned).toByteArrayAndResult();
        Assertions.assertArrayEquals((byte[])message, (byte[])bytesAndResult.getBytes());
        Assertions.assertFalse((boolean)((List)bytesAndResult.getResult()).isEmpty());
    }

    @Test
    public void assertNotBeforeThrowsNoSignature() {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.26.1");
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.27.2");
        byte[] message = "-----BEGIN PGP MESSAGE-----\n\nowGbwMvMwCX2yTCUx9/9cR/jaZEkBhDwSM3JyddRCM8vyklR5OooZWEQ42JQZ2VK\nPjjpPacATLmYIsvr1t3xi61KH8ZN8UuGCTMwpPcw/E9jS+vcvPu2gmp4jcRbcSNP\nFYmW8hmLJdUVrdt1V8w6GM/IMEvN0tP339sNGX4swq8T5p62q3jUfLjpstmcI6Ie\nsfcfswMA\n=RDAo\n-----END PGP MESSAGE-----".getBytes(StandardCharsets.UTF_8);
        Date signatureDate = UTCUtil.parseUTCDate((String)"2023-01-13T17:20:47Z");
        Date afterSignature = new Date(signatureDate.getTime() + 1000L);
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> ((InlineVerify)((InlineVerify)this.getSop().inlineVerify().notBefore(afterSignature)).cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(message).toByteArrayAndResult());
    }

    @Test
    public void assertNotAfterThrowsNoSignature() {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.26.1");
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.27.2");
        byte[] message = "-----BEGIN PGP MESSAGE-----\n\nowGbwMvMwCX2yTCUx9/9cR/jaZEkBhDwSM3JyddRCM8vyklR5OooZWEQ42JQZ2VK\nPjjpPacATLmYIsvr1t3xi61KH8ZN8UuGCTMwpPcw/E9jS+vcvPu2gmp4jcRbcSNP\nFYmW8hmLJdUVrdt1V8w6GM/IMEvN0tP339sNGX4swq8T5p62q3jUfLjpstmcI6Ie\nsfcfswMA\n=RDAo\n-----END PGP MESSAGE-----".getBytes(StandardCharsets.UTF_8);
        Date signatureDate = UTCUtil.parseUTCDate((String)"2023-01-13T17:20:47Z");
        Date beforeSignature = new Date(signatureDate.getTime() - 1000L);
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> ((InlineVerify)((InlineVerify)this.getSop().inlineVerify().notAfter(beforeSignature)).cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(message).toByteArrayAndResult());
    }

    @Test
    public void signVerifyWithPasswordProtectedKey() throws IOException {
        this.ignoreIf("sqop", AbstractExternalSOPTest.Is.leq, "0.26.1");
        byte[] message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] keyPassword = "sw0rdf1sh".getBytes(StandardCharsets.UTF_8);
        byte[] key = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").withKeyPassword(keyPassword).generate().getBytes();
        byte[] cert = this.getSop().extractCert().key(key).getBytes();
        byte[] inlineSigned = ((InlineSign)((InlineSign)this.getSop().inlineSign().withKeyPassword(keyPassword)).key(key)).mode(InlineSignAs.binary).data(message).getBytes();
        Assertions.assertFalse((boolean)((List)((InlineVerify)this.getSop().inlineVerify().cert(cert)).data(inlineSigned).toByteArrayAndResult().getResult()).isEmpty());
    }
}

