/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;

public class JUtils {
    public static boolean arrayStartsWith(byte[] array, byte[] start) {
        return JUtils.arrayStartsWith(array, start, 0);
    }

    public static boolean arrayStartsWith(byte[] array, byte[] start, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        if (start.length + offset > array.length) {
            return false;
        }
        for (int i = 0; i < start.length; ++i) {
            if (array[offset + i] == start[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertArrayStartsWith(byte[] array, byte[] start) {
        if (!JUtils.arrayStartsWith(array, start)) {
            byte[] actual = new byte[Math.min(start.length, array.length)];
            System.arraycopy(array, 0, actual, 0, actual.length);
            Assertions.fail((String)("Array does not start with expected bytes.\nExpected: <" + Arrays.toString(start) + ">\nActual: <" + Arrays.toString(actual) + ">"));
        }
    }

    public static void assertArrayStartsWith(byte[] array, byte[] start, int offset) {
        if (!JUtils.arrayStartsWith(array, start, offset)) {
            byte[] actual = new byte[Math.min(start.length, array.length - offset)];
            System.arraycopy(array, offset, actual, 0, actual.length);
            Assertions.fail((String)("Array does not start with expected bytes at offset " + offset + ".\nExpected: <" + Arrays.toString(start) + ">\nActual: <" + Arrays.toString(actual) + ">"));
        }
    }

    public static void assertAsciiArmorEquals(byte[] first, byte[] second) {
        byte[] firstCleaned = JUtils.removeArmorHeaders(first);
        byte[] secondCleaned = JUtils.removeArmorHeaders(second);
        Assertions.assertArrayEquals((byte[])firstCleaned, (byte[])secondCleaned);
    }

    public static byte[] removeArmorHeaders(byte[] armor) {
        String string = new String(armor, StandardCharsets.UTF_8);
        string = string.replaceAll("Comment: .+\\R", "").replaceAll("Version: .+\\R", "").replaceAll("MessageID: .+\\R", "").replaceAll("Hash: .+\\R", "").replaceAll("Charset: .+\\R", "");
        return string.getBytes(StandardCharsets.UTF_8);
    }
}

