/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sop.MicAlg;
import sop.ReadyWithResult;
import sop.SigningResult;
import sop.enums.SignAs;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.DetachedSign;

public class DetachedSignExternal
implements DetachedSign {
    private final ExternalSOP.TempDirProvider tempDirProvider;
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private int withKeyPasswordCounter = 0;
    private int keyCounter = 0;

    public DetachedSignExternal(String binary, Properties properties, ExternalSOP.TempDirProvider tempDirProvider) {
        this.tempDirProvider = tempDirProvider;
        this.commandList.add(binary);
        this.commandList.add("sign");
        this.envList = ExternalSOP.propertiesToEnv(properties);
    }

    public DetachedSign noArmor() {
        this.commandList.add("--no-armor");
        return this;
    }

    public DetachedSign key(InputStream key) throws SOPGPException.KeyCannotSign, SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        String envVar = "KEY_" + this.keyCounter++;
        this.commandList.add("@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readFully(key));
        return this;
    }

    public DetachedSign withKeyPassword(byte[] password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
        String envVar = "WITH_KEY_PASSWORD_" + this.withKeyPasswordCounter++;
        this.commandList.add("--with-key-password=@ENV:" + envVar);
        this.envList.add(envVar + "=" + new String(password));
        return this;
    }

    public DetachedSign mode(SignAs mode) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--as=" + mode);
        return this;
    }

    public ReadyWithResult<SigningResult> data(final InputStream data) throws IOException, SOPGPException.KeyIsProtected, SOPGPException.ExpectedText {
        File tempDir = this.tempDirProvider.provideTempDirectory();
        final File micAlgOut = new File(tempDir, "micAlgOut");
        micAlgOut.delete();
        this.commandList.add("--micalg-out=" + micAlgOut.getAbsolutePath());
        String[] command = this.commandList.toArray(new String[0]);
        String[] env = this.envList.toArray(new String[0]);
        try {
            final Process process = Runtime.getRuntime().exec(command, env);
            final OutputStream processOut = process.getOutputStream();
            final InputStream processIn = process.getInputStream();
            return new ReadyWithResult<SigningResult>(){

                public SigningResult writeTo(OutputStream outputStream) throws IOException {
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = data.read(buf)) > 0) {
                        processOut.write(buf, 0, r);
                    }
                    data.close();
                    processOut.close();
                    while ((r = processIn.read(buf)) > 0) {
                        outputStream.write(buf, 0, r);
                    }
                    processIn.close();
                    outputStream.close();
                    ExternalSOP.finish(process);
                    SigningResult.Builder builder = SigningResult.builder();
                    if (micAlgOut.exists()) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(micAlgOut)));
                        String line = reader.readLine();
                        if (line != null && !line.trim().isEmpty()) {
                            MicAlg micAlg = new MicAlg(line.trim());
                            builder.setMicAlg(micAlg);
                        }
                        reader.close();
                        micAlgOut.delete();
                    }
                    return builder.build();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

