/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.DetachedVerify;
import sop.operation.VerifySignatures;
import sop.util.UTCUtil;

public class DetachedVerifyExternal
implements DetachedVerify {
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private Set<InputStream> certs = new HashSet<InputStream>();
    private InputStream signatures;
    private int certCounter = 0;

    public DetachedVerifyExternal(String binary, Properties environment) {
        this.commandList.add(binary);
        this.commandList.add("verify");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public DetachedVerify notBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--not-before=" + UTCUtil.formatUTCDate((Date)timestamp));
        return this;
    }

    public DetachedVerify notAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--not-after=" + UTCUtil.formatUTCDate((Date)timestamp));
        return this;
    }

    public DetachedVerify cert(InputStream cert) throws SOPGPException.BadData, IOException {
        this.certs.add(cert);
        return this;
    }

    public VerifySignatures signatures(InputStream signatures) throws SOPGPException.BadData, IOException {
        this.signatures = signatures;
        return this;
    }

    public List<Verification> data(InputStream data) throws IOException, SOPGPException.NoSignature, SOPGPException.BadData {
        this.commandList.add("@ENV:SIGNATURE");
        this.envList.add("SIGNATURE=" + ExternalSOP.readFully(this.signatures));
        for (InputStream cert : this.certs) {
            String envVar = "CERT_" + this.certCounter++;
            this.commandList.add("@ENV:" + envVar);
            this.envList.add(envVar + "=" + ExternalSOP.readFully(cert));
        }
        String[] command = this.commandList.toArray(new String[0]);
        String[] env = this.envList.toArray(new String[0]);
        try {
            int r;
            Process process = Runtime.getRuntime().exec(command, env);
            OutputStream processOut = process.getOutputStream();
            InputStream processIn = process.getInputStream();
            byte[] buf = new byte[4096];
            while ((r = data.read(buf)) > 0) {
                processOut.write(buf, 0, r);
            }
            data.close();
            processOut.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(processIn));
            ArrayList<Verification> verifications = new ArrayList<Verification>();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                verifications.add(Verification.fromString((String)line));
            }
            ExternalSOP.finish(process);
            return verifications;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

