/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sop.Ready;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.Encrypt;

public class EncryptExternal
implements Encrypt {
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private int SIGN_WITH_COUNTER = 0;
    private int KEY_PASSWORD_COUNTER = 0;
    private int PASSWORD_COUNTER = 0;
    private int CERT_COUNTER = 0;

    public EncryptExternal(String binary, Properties environment) {
        this.commandList.add(binary);
        this.commandList.add("encrypt");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public Encrypt noArmor() {
        this.commandList.add("--no-armor");
        return this;
    }

    public Encrypt mode(EncryptAs mode) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--as=" + mode);
        return this;
    }

    public Encrypt signWith(InputStream key) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        String envVar = "SIGN_WITH_" + this.SIGN_WITH_COUNTER++;
        this.commandList.add("--sign-with=@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readFully(key));
        return this;
    }

    public Encrypt withKeyPassword(byte[] password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        String envVar = "KEY_PASSWORD_" + this.KEY_PASSWORD_COUNTER++;
        this.commandList.add("--with-key-password=@ENV:" + envVar);
        this.envList.add(envVar + "=" + new String(password));
        return this;
    }

    public Encrypt withPassword(String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        String envVar = "PASSWORD_" + this.PASSWORD_COUNTER++;
        this.commandList.add("--with-password=@ENV:" + envVar);
        this.envList.add(envVar + "=" + password);
        return this;
    }

    public Encrypt withCert(InputStream cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        String envVar = "CERT_" + this.CERT_COUNTER++;
        this.commandList.add("@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readFully(cert));
        return this;
    }

    public Ready plaintext(InputStream plaintext) throws IOException, SOPGPException.KeyIsProtected {
        return ExternalSOP.ready(Runtime.getRuntime(), this.commandList, this.envList, plaintext);
    }
}

