/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.GenerateKey;

public class GenerateKeyExternal
implements GenerateKey {
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private int keyPasswordCounter = 0;

    public GenerateKeyExternal(String binary, Properties environment) {
        this.commandList.add(binary);
        this.commandList.add("generate-key");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public GenerateKey noArmor() {
        this.commandList.add("--no-armor");
        return this;
    }

    public GenerateKey userId(String userId) {
        this.commandList.add(userId);
        return this;
    }

    public GenerateKey withKeyPassword(String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        this.commandList.add("--with-key-password=@ENV:KEY_PASSWORD_" + this.keyPasswordCounter);
        this.envList.add("KEY_PASSWORD_" + this.keyPasswordCounter + "=" + password);
        ++this.keyPasswordCounter;
        return this;
    }

    public Ready generate() throws SOPGPException.MissingArg, SOPGPException.UnsupportedAsymmetricAlgo {
        return ExternalSOP.ready(Runtime.getRuntime(), this.commandList, this.envList);
    }
}

