/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import sop.external.ExternalSOP;
import sop.operation.Version;

public class VersionExternal
implements Version {
    private final Runtime runtime = Runtime.getRuntime();
    private final String binary;
    private final Properties environment;

    public VersionExternal(String binaryName, Properties environment) {
        this.binary = binaryName;
        this.environment = environment;
    }

    public String getName() {
        String[] command = new String[]{this.binary, "version"};
        String[] env = ExternalSOP.propertiesToEnv(this.environment).toArray(new String[0]);
        try {
            Process process = this.runtime.exec(command, env);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = stdInput.readLine().trim();
            ExternalSOP.finish(process);
            if (line.contains(" ")) {
                return line.substring(0, line.lastIndexOf(" "));
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getVersion() {
        String[] command = new String[]{this.binary, "version"};
        String[] env = ExternalSOP.propertiesToEnv(this.environment).toArray(new String[0]);
        try {
            Process process = this.runtime.exec(command, env);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = stdInput.readLine().trim();
            ExternalSOP.finish(process);
            if (line.contains(" ")) {
                return line.substring(line.lastIndexOf(" ") + 1);
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBackendVersion() {
        String[] command = new String[]{this.binary, "version", "--backend"};
        String[] env = ExternalSOP.propertiesToEnv(this.environment).toArray(new String[0]);
        try {
            String line;
            Process process = this.runtime.exec(command, env);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = stdInput.readLine()) != null) {
                sb.append(line).append('\n');
            }
            ExternalSOP.finish(process);
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getExtendedVersion() {
        String[] command = new String[]{this.binary, "version", "--extended"};
        String[] env = ExternalSOP.propertiesToEnv(this.environment).toArray(new String[0]);
        try {
            String line;
            Process process = this.runtime.exec(command, env);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = stdInput.readLine()) != null) {
                sb.append(line).append('\n');
            }
            ExternalSOP.finish(process);
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

