/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sop.ReadyWithResult;
import sop.Signatures;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.InlineDetach;

public class InlineDetachExternal
implements InlineDetach {
    private final ExternalSOP.TempDirProvider tempDirProvider;
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;

    public InlineDetachExternal(String binary, Properties environment, ExternalSOP.TempDirProvider tempDirProvider) {
        this.tempDirProvider = tempDirProvider;
        this.commandList.add(binary);
        this.commandList.add("inline-detach");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public InlineDetach noArmor() {
        this.commandList.add("--no-armor");
        return this;
    }

    public ReadyWithResult<Signatures> message(final InputStream messageInputStream) throws IOException, SOPGPException.BadData {
        File tempDir = this.tempDirProvider.provideTempDirectory();
        final File signaturesOut = new File(tempDir, "signatures");
        signaturesOut.delete();
        this.commandList.add("--signatures-out=" + signaturesOut.getAbsolutePath());
        String[] command = this.commandList.toArray(new String[0]);
        String[] env = this.envList.toArray(new String[0]);
        try {
            final Process process = Runtime.getRuntime().exec(command, env);
            final OutputStream processOut = process.getOutputStream();
            final InputStream processIn = process.getInputStream();
            return new ReadyWithResult<Signatures>(){

                public Signatures writeTo(OutputStream outputStream) throws IOException {
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = messageInputStream.read(buf)) > 0) {
                        processOut.write(buf, 0, r);
                    }
                    messageInputStream.close();
                    processOut.close();
                    while ((r = processIn.read(buf)) > 0) {
                        outputStream.write(buf, 0, r);
                    }
                    processIn.close();
                    outputStream.close();
                    ExternalSOP.finish(process);
                    FileInputStream signaturesOutIn = new FileInputStream(signaturesOut);
                    ByteArrayOutputStream signaturesBuffer = new ByteArrayOutputStream();
                    while ((r = signaturesOutIn.read(buf)) > 0) {
                        signaturesBuffer.write(buf, 0, r);
                    }
                    signaturesOutIn.close();
                    signaturesOut.delete();
                    final byte[] sigBytes = signaturesBuffer.toByteArray();
                    return new Signatures(){

                        public void writeTo(OutputStream signatureOutputStream) throws IOException {
                            signatureOutputStream.write(sigBytes);
                        }
                    };
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

