/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.external;

import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import sop.SOP;
import sop.external.ExternalSOP;
import sop.testsuite.SOPInstanceFactory;

public class ExternalSOPInstanceFactory
extends SOPInstanceFactory {
    public Map<String, SOP> provideSOPInstances() {
        HashMap<String, SOP> backends = new HashMap<String, SOP>();
        TestSuite suite = ExternalSOPInstanceFactory.readConfiguration();
        if (suite != null && !suite.backends.isEmpty()) {
            for (TestSubject subject : suite.backends) {
                if (!new File(subject.sop).exists()) continue;
                Properties env = new Properties();
                if (subject.env != null) {
                    for (Var var : subject.env) {
                        env.put(var.key, var.value);
                    }
                }
                ExternalSOP sop = new ExternalSOP(subject.sop, env);
                backends.put(subject.name, (SOP)sop);
            }
        }
        return backends;
    }

    public static TestSuite readConfiguration() {
        Gson gson = new Gson();
        InputStream inputStream = ExternalSOPInstanceFactory.class.getResourceAsStream("config.json");
        if (inputStream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        return (TestSuite)gson.fromJson((Reader)reader, TestSuite.class);
    }

    public static class Var {
        String key;
        String value;
    }

    public static class TestSubject {
        String name;
        String sop;
        List<Var> env;
    }

    public static class TestSuite {
        List<TestSubject> backends;
    }
}

