/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import sop.Ready;
import sop.SOP;
import sop.exception.SOPGPException;
import sop.external.operation.ArmorExternal;
import sop.external.operation.DearmorExternal;
import sop.external.operation.DecryptExternal;
import sop.external.operation.DetachedSignExternal;
import sop.external.operation.DetachedVerifyExternal;
import sop.external.operation.EncryptExternal;
import sop.external.operation.ExtractCertExternal;
import sop.external.operation.GenerateKeyExternal;
import sop.external.operation.InlineDetachExternal;
import sop.external.operation.InlineSignExternal;
import sop.external.operation.InlineVerifyExternal;
import sop.external.operation.ListProfilesExternal;
import sop.external.operation.VersionExternal;
import sop.operation.Armor;
import sop.operation.Dearmor;
import sop.operation.Decrypt;
import sop.operation.DetachedSign;
import sop.operation.DetachedVerify;
import sop.operation.Encrypt;
import sop.operation.ExtractCert;
import sop.operation.GenerateKey;
import sop.operation.InlineDetach;
import sop.operation.InlineSign;
import sop.operation.InlineVerify;
import sop.operation.ListProfiles;
import sop.operation.Version;

public class ExternalSOP
implements SOP {
    private final String binaryName;
    private final Properties properties;
    private final TempDirProvider tempDirProvider;

    public ExternalSOP(@Nonnull String binaryName) {
        this(binaryName, new Properties());
    }

    public ExternalSOP(@Nonnull String binaryName, @Nonnull Properties properties) {
        this(binaryName, properties, ExternalSOP.defaultTempDirProvider());
    }

    public ExternalSOP(@Nonnull String binaryName, @Nonnull TempDirProvider tempDirProvider) {
        this(binaryName, new Properties(), tempDirProvider);
    }

    public ExternalSOP(@Nonnull String binaryName, @Nonnull Properties properties, @Nonnull TempDirProvider tempDirProvider) {
        this.binaryName = binaryName;
        this.properties = properties;
        this.tempDirProvider = tempDirProvider;
    }

    public Version version() {
        return new VersionExternal(this.binaryName, this.properties);
    }

    public GenerateKey generateKey() {
        return new GenerateKeyExternal(this.binaryName, this.properties);
    }

    public ExtractCert extractCert() {
        return new ExtractCertExternal(this.binaryName, this.properties);
    }

    public DetachedSign detachedSign() {
        return new DetachedSignExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    public InlineSign inlineSign() {
        return new InlineSignExternal(this.binaryName, this.properties);
    }

    public DetachedVerify detachedVerify() {
        return new DetachedVerifyExternal(this.binaryName, this.properties);
    }

    public InlineVerify inlineVerify() {
        return new InlineVerifyExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    public InlineDetach inlineDetach() {
        return new InlineDetachExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    public Encrypt encrypt() {
        return new EncryptExternal(this.binaryName, this.properties);
    }

    public Decrypt decrypt() {
        return new DecryptExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    public Armor armor() {
        return new ArmorExternal(this.binaryName, this.properties);
    }

    public ListProfiles listProfiles() {
        return new ListProfilesExternal(this.binaryName, this.properties);
    }

    public Dearmor dearmor() {
        return new DearmorExternal(this.binaryName, this.properties);
    }

    public static void finish(@Nonnull Process process) throws IOException {
        try {
            ExternalSOP.mapExitCodeOrException(process);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void mapExitCodeOrException(@Nonnull Process process) throws InterruptedException, IOException {
        int exitCode = process.waitFor();
        if (exitCode == 0) {
            return;
        }
        InputStream errIn = process.getErrorStream();
        String errorMessage = ExternalSOP.readString(errIn);
        switch (exitCode) {
            case 3: {
                throw new SOPGPException.NoSignature("External SOP backend reported error NoSignature (" + exitCode + "):\n" + errorMessage);
            }
            case 13: {
                throw new UnsupportedOperationException("External SOP backend reported error UnsupportedAsymmetricAlgo (" + exitCode + "):\n" + errorMessage);
            }
            case 17: {
                throw new SOPGPException.CertCannotEncrypt("External SOP backend reported error CertCannotEncrypt (" + exitCode + "):\n" + errorMessage);
            }
            case 19: {
                throw new SOPGPException.MissingArg("External SOP backend reported error MissingArg (" + exitCode + "):\n" + errorMessage);
            }
            case 23: {
                throw new SOPGPException.IncompleteVerification("External SOP backend reported error IncompleteVerification (" + exitCode + "):\n" + errorMessage);
            }
            case 29: {
                throw new SOPGPException.CannotDecrypt("External SOP backend reported error CannotDecrypt (" + exitCode + "):\n" + errorMessage);
            }
            case 31: {
                throw new SOPGPException.PasswordNotHumanReadable("External SOP backend reported error PasswordNotHumanReadable (" + exitCode + "):\n" + errorMessage);
            }
            case 37: {
                throw new SOPGPException.UnsupportedOption("External SOP backend reported error UnsupportedOption (" + exitCode + "):\n" + errorMessage);
            }
            case 41: {
                throw new SOPGPException.BadData("External SOP backend reported error BadData (" + exitCode + "):\n" + errorMessage);
            }
            case 53: {
                throw new SOPGPException.ExpectedText("External SOP backend reported error ExpectedText (" + exitCode + "):\n" + errorMessage);
            }
            case 59: {
                throw new SOPGPException.OutputExists("External SOP backend reported error OutputExists (" + exitCode + "):\n" + errorMessage);
            }
            case 61: {
                throw new SOPGPException.MissingInput("External SOP backend reported error MissingInput (" + exitCode + "):\n" + errorMessage);
            }
            case 67: {
                throw new SOPGPException.KeyIsProtected("External SOP backend reported error KeyIsProtected (" + exitCode + "):\n" + errorMessage);
            }
            case 69: {
                throw new SOPGPException.UnsupportedSubcommand("External SOP backend reported error UnsupportedSubcommand (" + exitCode + "):\n" + errorMessage);
            }
            case 71: {
                throw new SOPGPException.UnsupportedSpecialPrefix("External SOP backend reported error UnsupportedSpecialPrefix (" + exitCode + "):\n" + errorMessage);
            }
            case 73: {
                throw new SOPGPException.AmbiguousInput("External SOP backend reported error AmbiguousInput (" + exitCode + "):\n" + errorMessage);
            }
            case 79: {
                throw new SOPGPException.KeyCannotSign("External SOP backend reported error KeyCannotSign (" + exitCode + "):\n" + errorMessage);
            }
            case 83: {
                throw new SOPGPException.IncompatibleOptions("External SOP backend reported error IncompatibleOptions (" + exitCode + "):\n" + errorMessage);
            }
            case 89: {
                throw new SOPGPException.UnsupportedProfile("External SOP backend reported error UnsupportedProfile (" + exitCode + "):\n" + errorMessage);
            }
        }
        throw new RuntimeException("External SOP backend reported unknown exit code (" + exitCode + "):\n" + errorMessage);
    }

    public static List<String> propertiesToEnv(@Nonnull Properties properties) {
        ArrayList<String> env = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            env.add(key + "=" + properties.get(key));
        }
        return env;
    }

    public static String readString(@Nonnull InputStream inputStream) throws IOException {
        int r;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((r = inputStream.read(buf)) > 0) {
            bOut.write(buf, 0, r);
        }
        return bOut.toString();
    }

    public static Ready executeProducingOperation(@Nonnull Runtime runtime, @Nonnull List<String> commandList, @Nonnull List<String> envList) {
        String[] command = commandList.toArray(new String[0]);
        String[] env = envList.toArray(new String[0]);
        try {
            final Process process = runtime.exec(command, env);
            final InputStream stdIn = process.getInputStream();
            return new Ready(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = stdIn.read(buf)) >= 0) {
                        outputStream.write(buf, 0, r);
                    }
                    outputStream.flush();
                    outputStream.close();
                    ExternalSOP.finish(process);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Ready executeTransformingOperation(@Nonnull Runtime runtime, @Nonnull List<String> commandList, @Nonnull List<String> envList, final @Nonnull InputStream standardIn) {
        String[] command = commandList.toArray(new String[0]);
        String[] env = envList.toArray(new String[0]);
        try {
            final Process process = runtime.exec(command, env);
            final OutputStream processOut = process.getOutputStream();
            final InputStream processIn = process.getInputStream();
            return new Ready(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    int r;
                    byte[] buf;
                    block4: {
                        buf = new byte[4096];
                        while ((r = standardIn.read(buf)) > 0) {
                            processOut.write(buf, 0, r);
                        }
                        standardIn.close();
                        try {
                            processOut.flush();
                            processOut.close();
                        }
                        catch (IOException e) {
                            if ("Stream closed".equals(e.getMessage())) break block4;
                            throw e;
                        }
                    }
                    while ((r = processIn.read(buf)) > 0) {
                        outputStream.write(buf, 0, r);
                    }
                    processIn.close();
                    outputStream.flush();
                    outputStream.close();
                    ExternalSOP.finish(process);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TempDirProvider defaultTempDirProvider() {
        return new TempDirProvider(){

            @Override
            public File provideTempDirectory() throws IOException {
                return Files.createTempDirectory("ext-sop", new FileAttribute[0]).toFile();
            }
        };
    }

    public static interface TempDirProvider {
        public File provideTempDirectory() throws IOException;
    }
}

