/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sop.Profile;
import sop.external.ExternalSOP;
import sop.operation.ListProfiles;

public class ListProfilesExternal
implements ListProfiles {
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;

    public ListProfilesExternal(String binary, Properties properties) {
        this.commandList.add(binary);
        this.commandList.add("list-profiles");
        this.envList = ExternalSOP.propertiesToEnv(properties);
    }

    public List<Profile> subcommand(String command) {
        this.commandList.add(command);
        try {
            String output = new String(ExternalSOP.executeProducingOperation(Runtime.getRuntime(), this.commandList, this.envList).getBytes());
            return ListProfilesExternal.toProfiles(output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Profile> toProfiles(String output) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (String line : output.split("\n")) {
            String[] split = line.split(": ");
            profiles.add(new Profile(split[0], split[1]));
        }
        return profiles;
    }
}

