/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.Decrypt;
import sop.util.UTCUtil;

public class DecryptExternal
implements Decrypt {
    private final ExternalSOP.TempDirProvider tempDirProvider;
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private int verifyWithCounter = 0;
    private int withSessionKeyCounter = 0;
    private int withPasswordCounter = 0;
    private int keyCounter = 0;
    private int withKeyPasswordCounter = 0;

    public DecryptExternal(String binary, Properties environment, ExternalSOP.TempDirProvider tempDirProvider) {
        this.tempDirProvider = tempDirProvider;
        this.commandList.add(binary);
        this.commandList.add("decrypt");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public Decrypt verifyNotBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--verify-not-before=" + UTCUtil.formatUTCDate((Date)timestamp));
        return this;
    }

    public Decrypt verifyNotAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--verify-not-after=" + UTCUtil.formatUTCDate((Date)timestamp));
        return this;
    }

    public Decrypt verifyWithCert(InputStream cert) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        String envVar = "VERIFY_WITH_" + this.verifyWithCounter++;
        this.commandList.add("--verify-with=@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readString(cert));
        return this;
    }

    public Decrypt withSessionKey(SessionKey sessionKey) throws SOPGPException.UnsupportedOption {
        String envVar = "SESSION_KEY_" + this.withSessionKeyCounter++;
        this.commandList.add("--with-session-key=@ENV:" + envVar);
        this.envList.add(envVar + "=" + sessionKey);
        return this;
    }

    public Decrypt withPassword(String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        String envVar = "PASSWORD_" + this.withPasswordCounter++;
        this.commandList.add("--with-password=@ENV:" + envVar);
        this.envList.add(envVar + "=" + password);
        return this;
    }

    public Decrypt withKey(InputStream key) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        String envVar = "KEY_" + this.keyCounter++;
        this.commandList.add("@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readString(key));
        return this;
    }

    public Decrypt withKeyPassword(byte[] password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
        String envVar = "KEY_PASSWORD_" + this.withKeyPasswordCounter++;
        this.commandList.add("--with-key-password=@ENV:" + envVar);
        this.envList.add(envVar + "=" + new String(password));
        return this;
    }

    public ReadyWithResult<DecryptionResult> ciphertext(final InputStream ciphertext) throws SOPGPException.BadData, SOPGPException.MissingArg, SOPGPException.CannotDecrypt, SOPGPException.KeyIsProtected, IOException {
        File tempDir = this.tempDirProvider.provideTempDirectory();
        final File sessionKeyOut = new File(tempDir, "session-key-out");
        sessionKeyOut.delete();
        this.commandList.add("--session-key-out=" + sessionKeyOut.getAbsolutePath());
        final File verifyOut = new File(tempDir, "verifications-out");
        verifyOut.delete();
        if (this.verifyWithCounter != 0) {
            this.commandList.add("--verify-out=" + verifyOut.getAbsolutePath());
        }
        String[] command = this.commandList.toArray(new String[0]);
        String[] env = this.envList.toArray(new String[0]);
        try {
            final Process process = Runtime.getRuntime().exec(command, env);
            final OutputStream processOut = process.getOutputStream();
            final InputStream processIn = process.getInputStream();
            return new ReadyWithResult<DecryptionResult>(){

                public DecryptionResult writeTo(OutputStream outputStream) throws IOException {
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = ciphertext.read(buf)) > 0) {
                        processOut.write(buf, 0, r);
                    }
                    ciphertext.close();
                    processOut.close();
                    while ((r = processIn.read(buf)) > 0) {
                        outputStream.write(buf, 0, r);
                    }
                    processIn.close();
                    outputStream.close();
                    ExternalSOP.finish(process);
                    FileInputStream sessionKeyOutIn = new FileInputStream(sessionKeyOut);
                    String line = ExternalSOP.readString(sessionKeyOutIn);
                    SessionKey sessionKey = SessionKey.fromString((String)line.trim());
                    sessionKeyOutIn.close();
                    sessionKeyOut.delete();
                    ArrayList<Verification> verifications = new ArrayList<Verification>();
                    if (DecryptExternal.this.verifyWithCounter != 0) {
                        FileInputStream verifyOutIn = new FileInputStream(verifyOut);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(verifyOutIn));
                        while ((line = reader.readLine()) != null) {
                            verifications.add(Verification.fromString((String)line.trim()));
                        }
                        reader.close();
                    }
                    return new DecryptionResult(sessionKey, verifications);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

