/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sop.Ready;
import sop.enums.InlineSignAs;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.InlineSign;

public class InlineSignExternal
implements InlineSign {
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private int keyCounter = 0;
    private int withKeyPasswordCounter = 0;

    public InlineSignExternal(String binary, Properties environment) {
        this.commandList.add(binary);
        this.commandList.add("inline-sign");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public InlineSign noArmor() {
        this.commandList.add("--no-armor");
        return this;
    }

    public InlineSign key(InputStream key) throws SOPGPException.KeyCannotSign, SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        String envVar = "KEY_" + this.keyCounter++;
        this.commandList.add("@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readString(key));
        return this;
    }

    public InlineSign withKeyPassword(byte[] password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
        String envVar = "WITH_KEY_PASSWORD_" + this.withKeyPasswordCounter++;
        this.commandList.add("--with-key-password=@ENV:" + envVar);
        this.envList.add(envVar + "=" + new String(password));
        return this;
    }

    public InlineSign mode(InlineSignAs mode) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--as=" + mode);
        return this;
    }

    public Ready data(InputStream data) throws SOPGPException.KeyIsProtected, SOPGPException.ExpectedText {
        return ExternalSOP.executeTransformingOperation(Runtime.getRuntime(), this.commandList, this.envList, data);
    }
}

