/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import sop.ReadyWithResult;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.InlineVerify;
import sop.util.UTCUtil;

public class InlineVerifyExternal
implements InlineVerify {
    private final ExternalSOP.TempDirProvider tempDirProvider;
    private final List<String> commandList = new ArrayList<String>();
    private final List<String> envList;
    private int certCounter = 0;

    public InlineVerifyExternal(String binary, Properties environment, ExternalSOP.TempDirProvider tempDirProvider) {
        this.tempDirProvider = tempDirProvider;
        this.commandList.add(binary);
        this.commandList.add("inline-verify");
        this.envList = ExternalSOP.propertiesToEnv(environment);
    }

    public InlineVerify notBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--not-before=" + UTCUtil.formatUTCDate((Date)timestamp));
        return this;
    }

    public InlineVerify notAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.commandList.add("--not-after=" + UTCUtil.formatUTCDate((Date)timestamp));
        return this;
    }

    public InlineVerify cert(InputStream cert) throws SOPGPException.BadData, IOException {
        String envVar = "CERT_" + this.certCounter++;
        this.commandList.add("@ENV:" + envVar);
        this.envList.add(envVar + "=" + ExternalSOP.readString(cert));
        return this;
    }

    public ReadyWithResult<List<Verification>> data(final InputStream data) throws IOException, SOPGPException.NoSignature, SOPGPException.BadData {
        File tempDir = this.tempDirProvider.provideTempDirectory();
        final File verificationsOut = new File(tempDir, "verifications-out");
        verificationsOut.delete();
        this.commandList.add("--verifications-out=" + verificationsOut.getAbsolutePath());
        String[] command = this.commandList.toArray(new String[0]);
        String[] env = this.envList.toArray(new String[0]);
        try {
            final Process process = Runtime.getRuntime().exec(command, env);
            final OutputStream processOut = process.getOutputStream();
            final InputStream processIn = process.getInputStream();
            return new ReadyWithResult<List<Verification>>(){

                public List<Verification> writeTo(OutputStream outputStream) throws IOException, SOPGPException.NoSignature {
                    String line;
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = data.read(buf)) > 0) {
                        processOut.write(buf, 0, r);
                    }
                    data.close();
                    processOut.close();
                    while ((r = processIn.read(buf)) > 0) {
                        outputStream.write(buf, 0, r);
                    }
                    processIn.close();
                    outputStream.close();
                    ExternalSOP.finish(process);
                    FileInputStream verificationsOutIn = new FileInputStream(verificationsOut);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(verificationsOutIn));
                    ArrayList<Verification> verificationList = new ArrayList<Verification>();
                    while ((line = reader.readLine()) != null) {
                        verificationList.add(Verification.fromString((String)line.trim()));
                    }
                    return verificationList;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

