/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import sop.EncryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.enums.EncryptAs;
import sop.external.ExternalSOP;
import sop.operation.Encrypt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0001H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lsop/external/operation/EncryptExternal;", "Lsop/operation/Encrypt;", "binary", "", "environment", "Ljava/util/Properties;", "tempDirProvider", "Lsop/external/ExternalSOP$TempDirProvider;", "(Ljava/lang/String;Ljava/util/Properties;Lsop/external/ExternalSOP$TempDirProvider;)V", "argCounter", "", "commandList", "", "envList", "mode", "Lsop/enums/EncryptAs;", "noArmor", "plaintext", "Lsop/ReadyWithResult;", "Lsop/EncryptionResult;", "Ljava/io/InputStream;", "profile", "profileName", "signWith", "key", "withCert", "cert", "withKeyPassword", "password", "", "withPassword", "external-sop"})
@SourceDebugExtension(value={"SMAP\nEncryptExternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptExternal.kt\nsop/external/operation/EncryptExternal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,112:1\n1#2:113\n37#3,2:114\n*S KotlinDebug\n*F\n+ 1 EncryptExternal.kt\nsop/external/operation/EncryptExternal\n*L\n74#1:114,2\n*E\n"})
public final class EncryptExternal
implements Encrypt {
    @NotNull
    private final ExternalSOP.TempDirProvider tempDirProvider;
    @NotNull
    private final List<String> commandList;
    @NotNull
    private final List<String> envList;
    private int argCounter;

    public EncryptExternal(@NotNull String binary, @NotNull Properties environment, @NotNull ExternalSOP.TempDirProvider tempDirProvider) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempDirProvider, (String)"tempDirProvider");
        this.tempDirProvider = tempDirProvider;
        Object[] objectArray = new String[]{binary, "encrypt"};
        this.commandList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.envList = CollectionsKt.toMutableList((Collection)ExternalSOP.Companion.propertiesToEnv(environment));
    }

    @NotNull
    public Encrypt noArmor() {
        EncryptExternal encryptExternal;
        EncryptExternal $this$noArmor_u24lambda_u240 = encryptExternal = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u240.commandList.add("--no-armor");
        return encryptExternal;
    }

    @NotNull
    public Encrypt mode(@NotNull EncryptAs mode) {
        EncryptExternal encryptExternal;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        EncryptExternal $this$mode_u24lambda_u241 = encryptExternal = this;
        boolean bl = false;
        $this$mode_u24lambda_u241.commandList.add("--as=" + mode);
        return encryptExternal;
    }

    @NotNull
    public Encrypt signWith(@NotNull InputStream key) {
        EncryptExternal encryptExternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        EncryptExternal $this$signWith_u24lambda_u242 = encryptExternal = this;
        boolean bl = false;
        $this$signWith_u24lambda_u242.commandList.add("--sign-with@ENV:SIGN_WITH_" + $this$signWith_u24lambda_u242.argCounter);
        $this$signWith_u24lambda_u242.envList.add("SIGN_WITH_" + $this$signWith_u24lambda_u242.argCounter + '=' + ExternalSOP.Companion.readString(key));
        ++$this$signWith_u24lambda_u242.argCounter;
        return encryptExternal;
    }

    @NotNull
    public Encrypt withKeyPassword(@NotNull byte[] password) {
        EncryptExternal encryptExternal;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        EncryptExternal $this$withKeyPassword_u24lambda_u243 = encryptExternal = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u243.commandList.add("--with-key-password=@ENV:KEY_PASSWORD_" + $this$withKeyPassword_u24lambda_u243.argCounter);
        $this$withKeyPassword_u24lambda_u243.envList.add("KEY_PASSWORD_" + $this$withKeyPassword_u24lambda_u243.argCounter + '=' + new String(password, Charsets.UTF_8));
        ++$this$withKeyPassword_u24lambda_u243.argCounter;
        return encryptExternal;
    }

    @NotNull
    public Encrypt withPassword(@NotNull String password) {
        EncryptExternal encryptExternal;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        EncryptExternal $this$withPassword_u24lambda_u244 = encryptExternal = this;
        boolean bl = false;
        $this$withPassword_u24lambda_u244.commandList.add("--with-password=@ENV:PASSWORD_" + $this$withPassword_u24lambda_u244.argCounter);
        $this$withPassword_u24lambda_u244.envList.add("PASSWORD_" + $this$withPassword_u24lambda_u244.argCounter + '=' + password);
        ++$this$withPassword_u24lambda_u244.argCounter;
        return encryptExternal;
    }

    @NotNull
    public Encrypt withCert(@NotNull InputStream cert) {
        EncryptExternal encryptExternal;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        EncryptExternal $this$withCert_u24lambda_u245 = encryptExternal = this;
        boolean bl = false;
        $this$withCert_u24lambda_u245.commandList.add("@ENV:CERT_" + $this$withCert_u24lambda_u245.argCounter);
        $this$withCert_u24lambda_u245.envList.add("CERT_" + $this$withCert_u24lambda_u245.argCounter + '=' + ExternalSOP.Companion.readString(cert));
        ++$this$withCert_u24lambda_u245.argCounter;
        return encryptExternal;
    }

    @NotNull
    public Encrypt profile(@NotNull String profileName) {
        EncryptExternal encryptExternal;
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        EncryptExternal $this$profile_u24lambda_u246 = encryptExternal = this;
        boolean bl = false;
        $this$profile_u24lambda_u246.commandList.add("--profile=" + profileName);
        return encryptExternal;
    }

    @NotNull
    public ReadyWithResult<EncryptionResult> plaintext(@NotNull InputStream plaintext2) {
        Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
        File tempDir = this.tempDirProvider.provideTempDirectory();
        File sessionKeyOut = new File(tempDir, "session-key-out");
        sessionKeyOut.delete();
        this.commandList.add("--session-key-out=" + sessionKeyOut.getAbsolutePath());
        try {
            Collection $this$toTypedArray$iv = this.commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            OutputStream processOut = process.getOutputStream();
            InputStream processIn = process.getInputStream();
            return (ReadyWithResult)new ReadyWithResult<EncryptionResult>(plaintext2, processOut, processIn, process, sessionKeyOut){
                final /* synthetic */ InputStream $plaintext;
                final /* synthetic */ OutputStream $processOut;
                final /* synthetic */ InputStream $processIn;
                final /* synthetic */ Process $process;
                final /* synthetic */ File $sessionKeyOut;
                {
                    this.$plaintext = $plaintext;
                    this.$processOut = $processOut;
                    this.$processIn = $processIn;
                    this.$process = $process;
                    this.$sessionKeyOut = $sessionKeyOut;
                }

                @NotNull
                public EncryptionResult writeTo(@NotNull OutputStream outputStream) {
                    int it;
                    int n;
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    byte[] buf = new byte[4096];
                    int r = 0;
                    while (true) {
                        it = n = this.$plaintext.read(buf);
                        boolean bl = false;
                        r = it;
                        if (n <= 0) break;
                        this.$processOut.write(buf, 0, r);
                    }
                    this.$plaintext.close();
                    this.$processOut.close();
                    while (true) {
                        it = n = this.$processIn.read(buf);
                        boolean bl = false;
                        r = it;
                        if (n <= 0) break;
                        outputStream.write(buf, 0, r);
                    }
                    this.$processIn.close();
                    outputStream.close();
                    Process process = this.$process;
                    Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
                    ExternalSOP.Companion.finish(process);
                    FileInputStream sessionKeyOutIn = new FileInputStream(this.$sessionKeyOut);
                    String line = ExternalSOP.Companion.readString(sessionKeyOutIn);
                    SessionKey sessionKey = SessionKey.Companion.fromString(((Object)StringsKt.trim((CharSequence)line)).toString());
                    sessionKeyOutIn.close();
                    this.$sessionKeyOut.delete();
                    return new EncryptionResult(sessionKey);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

