/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import sop.ReadyWithResult;
import sop.Verification;
import sop.external.ExternalSOP;
import sop.operation.InlineVerify;
import sop.util.UTCUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsop/external/operation/InlineVerifyExternal;", "Lsop/operation/InlineVerify;", "binary", "", "environment", "Ljava/util/Properties;", "tempDirProvider", "Lsop/external/ExternalSOP$TempDirProvider;", "(Ljava/lang/String;Ljava/util/Properties;Lsop/external/ExternalSOP$TempDirProvider;)V", "argCounter", "", "commandList", "", "envList", "cert", "Ljava/io/InputStream;", "data", "Lsop/ReadyWithResult;", "", "Lsop/Verification;", "notAfter", "timestamp", "Ljava/util/Date;", "notBefore", "external-sop"})
@SourceDebugExtension(value={"SMAP\nInlineVerifyExternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineVerifyExternal.kt\nsop/external/operation/InlineVerifyExternal\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,92:1\n37#2,2:93\n*S KotlinDebug\n*F\n+ 1 InlineVerifyExternal.kt\nsop/external/operation/InlineVerifyExternal\n*L\n38#1:93,2\n*E\n"})
public final class InlineVerifyExternal
implements InlineVerify {
    @NotNull
    private final ExternalSOP.TempDirProvider tempDirProvider;
    @NotNull
    private final List<String> commandList;
    @NotNull
    private final List<String> envList;
    private int argCounter;

    public InlineVerifyExternal(@NotNull String binary, @NotNull Properties environment, @NotNull ExternalSOP.TempDirProvider tempDirProvider) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempDirProvider, (String)"tempDirProvider");
        this.tempDirProvider = tempDirProvider;
        Object[] objectArray = new String[]{binary, "inline-verify"};
        this.commandList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.envList = CollectionsKt.toMutableList((Collection)ExternalSOP.Companion.propertiesToEnv(environment));
    }

    @NotNull
    public ReadyWithResult<List<Verification>> data(@NotNull InputStream data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        File tempDir = this.tempDirProvider.provideTempDirectory();
        File verificationsOut = new File(tempDir, "verifications-out");
        verificationsOut.delete();
        this.commandList.add("--verifications-out=" + verificationsOut.getAbsolutePath());
        try {
            Collection $this$toTypedArray$iv = this.commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            OutputStream processOut = process.getOutputStream();
            InputStream processIn = process.getInputStream();
            return (ReadyWithResult)new ReadyWithResult<List<? extends Verification>>(data2, processOut, processIn, process, verificationsOut){
                final /* synthetic */ InputStream $data;
                final /* synthetic */ OutputStream $processOut;
                final /* synthetic */ InputStream $processIn;
                final /* synthetic */ Process $process;
                final /* synthetic */ File $verificationsOut;
                {
                    this.$data = $data;
                    this.$processOut = $processOut;
                    this.$processIn = $processIn;
                    this.$process = $process;
                    this.$verificationsOut = $verificationsOut;
                }

                @NotNull
                public List<Verification> writeTo(@NotNull OutputStream outputStream) {
                    int it;
                    int n;
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    byte[] buf = new byte[4096];
                    int r = 0;
                    while (true) {
                        it = n = this.$data.read(buf);
                        boolean bl = false;
                        r = it;
                        if (n <= 0) break;
                        this.$processOut.write(buf, 0, r);
                    }
                    this.$data.close();
                    this.$processOut.close();
                    while (true) {
                        it = n = this.$processIn.read(buf);
                        boolean bl = false;
                        r = it;
                        if (n <= 0) break;
                        outputStream.write(buf, 0, r);
                    }
                    this.$processIn.close();
                    outputStream.close();
                    Process process = this.$process;
                    Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
                    ExternalSOP.Companion.finish(process);
                    FileInputStream verificationsOutIn = new FileInputStream(this.$verificationsOut);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(verificationsOutIn));
                    List verificationList = new ArrayList<E>();
                    String line = null;
                    while (true) {
                        String string;
                        String it2 = string = reader.readLine();
                        boolean bl = false;
                        line = it2;
                        if (string == null) break;
                        String string2 = line;
                        Intrinsics.checkNotNull((Object)string2);
                        verificationList.add(Verification.Companion.fromString(((Object)StringsKt.trim((CharSequence)string2)).toString()));
                    }
                    return verificationList;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public InlineVerify notBefore(@NotNull Date timestamp) {
        InlineVerifyExternal inlineVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        InlineVerifyExternal $this$notBefore_u24lambda_u240 = inlineVerifyExternal = this;
        boolean bl = false;
        $this$notBefore_u24lambda_u240.commandList.add("--not-before=" + UTCUtil.Companion.formatUTCDate(timestamp));
        return inlineVerifyExternal;
    }

    @NotNull
    public InlineVerify notAfter(@NotNull Date timestamp) {
        InlineVerifyExternal inlineVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        InlineVerifyExternal $this$notAfter_u24lambda_u241 = inlineVerifyExternal = this;
        boolean bl = false;
        $this$notAfter_u24lambda_u241.commandList.add("--not-after=" + UTCUtil.Companion.formatUTCDate(timestamp));
        return inlineVerifyExternal;
    }

    @NotNull
    public InlineVerify cert(@NotNull InputStream cert) {
        InlineVerifyExternal inlineVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        InlineVerifyExternal $this$cert_u24lambda_u242 = inlineVerifyExternal = this;
        boolean bl = false;
        $this$cert_u24lambda_u242.commandList.add("@ENV:CERT_" + $this$cert_u24lambda_u242.argCounter);
        $this$cert_u24lambda_u242.envList.add("CERT_" + $this$cert_u24lambda_u242.argCounter + '=' + ExternalSOP.Companion.readString(cert));
        ++$this$cert_u24lambda_u242.argCounter;
        return inlineVerifyExternal;
    }
}

