/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeyRingTemplates;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.ArmorUtils;

public final class PGPainless {
    private PGPainless() {
    }

    public static KeyRingTemplates generateKeyRing() {
        return new KeyRingTemplates();
    }

    public static KeyRingBuilder buildKeyRing() {
        return new KeyRingBuilder();
    }

    public static KeyRingReader readKeyRing() {
        return new KeyRingReader();
    }

    public static PGPPublicKeyRing extractCertificate(@Nonnull PGPSecretKeyRing secretKey) {
        return KeyRingUtils.publicKeyRingFrom(secretKey);
    }

    public static String asciiArmor(@Nonnull PGPKeyRing key) throws IOException {
        if (key instanceof PGPSecretKeyRing) {
            return ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)key);
        }
        return ArmorUtils.toAsciiArmoredString((PGPPublicKeyRing)key);
    }

    public static EncryptionBuilder encryptAndOrSign() {
        return new EncryptionBuilder();
    }

    public static DecryptionBuilder decryptAndOrVerify() {
        return new DecryptionBuilder();
    }

    public static SecretKeyRingEditorInterface modifyKeyRing(PGPSecretKeyRing secretKeys) {
        return new SecretKeyRingEditor(secretKeys);
    }

    public static KeyRingInfo inspectKeyRing(PGPKeyRing keyRing) {
        return new KeyRingInfo(keyRing);
    }

    public static Policy getPolicy() {
        return Policy.getInstance();
    }
}

