/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pgp.cert_d.LockingMechanism;
import pgp.cert_d.SharedPGPCertificateDirectory;
import pgp.certificate_store.Certificate;
import pgp.certificate_store.MergeCallback;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;

public class CachingSharedPGPCertificateDirectoryWrapper
implements SharedPGPCertificateDirectory {
    private static final Map<String, String> tagMap = new HashMap<String, String>();
    private static final Map<String, Certificate> certificateMap = new HashMap<String, Certificate>();
    private final SharedPGPCertificateDirectory underlyingCertificateDirectory;

    public CachingSharedPGPCertificateDirectoryWrapper(SharedPGPCertificateDirectory wrapped) {
        this.underlyingCertificateDirectory = wrapped;
    }

    private void remember(String identifier, Certificate certificate) {
        certificateMap.put(identifier, certificate);
        try {
            tagMap.put(identifier, certificate.getTag());
        }
        catch (IOException e) {
            tagMap.put(identifier, null);
        }
    }

    private boolean tagChanged(String identifier, String tag) {
        String tack = tagMap.get(identifier);
        return !CachingSharedPGPCertificateDirectoryWrapper.tagEquals(tag, tack);
    }

    private static boolean tagEquals(String tag, String tack) {
        return tag == null && tack == null || tag != null && tag.equals(tack);
    }

    public void invalidate() {
        certificateMap.clear();
        tagMap.clear();
    }

    @Override
    public LockingMechanism getLock() {
        return this.underlyingCertificateDirectory.getLock();
    }

    @Override
    public Certificate getByFingerprint(String fingerprint) throws IOException, BadNameException, BadDataException {
        Certificate certificate = certificateMap.get(fingerprint);
        if (certificate == null && (certificate = this.underlyingCertificateDirectory.getByFingerprint(fingerprint)) != null) {
            this.remember(fingerprint, certificate);
        }
        return certificate;
    }

    @Override
    public Certificate getBySpecialName(String specialName) throws IOException, BadNameException, BadDataException {
        Certificate certificate = certificateMap.get(specialName);
        if (certificate == null && (certificate = this.underlyingCertificateDirectory.getBySpecialName(specialName)) != null) {
            this.remember(specialName, certificate);
        }
        return certificate;
    }

    @Override
    public Certificate getByFingerprintIfChanged(String fingerprint, String tag) throws IOException, BadNameException, BadDataException {
        if (this.tagChanged(fingerprint, tag)) {
            return this.getByFingerprint(fingerprint);
        }
        return null;
    }

    @Override
    public Certificate getBySpecialNameIfChanged(String specialName, String tag) throws IOException, BadNameException, BadDataException {
        if (this.tagChanged(specialName, tag)) {
            return this.getBySpecialName(specialName);
        }
        return null;
    }

    @Override
    public Certificate insert(InputStream data, MergeCallback merge) throws IOException, BadDataException, InterruptedException {
        Certificate certificate = this.underlyingCertificateDirectory.insert(data, merge);
        this.remember(certificate.getFingerprint(), certificate);
        return certificate;
    }

    @Override
    public Certificate tryInsert(InputStream data, MergeCallback merge) throws IOException, BadDataException {
        Certificate certificate = this.underlyingCertificateDirectory.tryInsert(data, merge);
        if (certificate != null) {
            this.remember(certificate.getFingerprint(), certificate);
        }
        return certificate;
    }

    @Override
    public Certificate insertWithSpecialName(String specialName, InputStream data, MergeCallback merge) throws IOException, BadDataException, BadNameException, InterruptedException {
        Certificate certificate = this.underlyingCertificateDirectory.insertWithSpecialName(specialName, data, merge);
        this.remember(specialName, certificate);
        return certificate;
    }

    @Override
    public Certificate tryInsertWithSpecialName(String specialName, InputStream data, MergeCallback merge) throws IOException, BadDataException, BadNameException {
        Certificate certificate = this.underlyingCertificateDirectory.tryInsertWithSpecialName(specialName, data, merge);
        if (certificate != null) {
            this.remember(specialName, certificate);
        }
        return certificate;
    }

    @Override
    public Iterator<Certificate> items() {
        final Iterator<Certificate> iterator = this.underlyingCertificateDirectory.items();
        return new Iterator<Certificate>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Certificate next() {
                Certificate certificate = (Certificate)iterator.next();
                CachingSharedPGPCertificateDirectoryWrapper.this.remember(certificate.getFingerprint(), certificate);
                return certificate;
            }
        };
    }

    @Override
    public Iterator<String> fingerprints() {
        return this.underlyingCertificateDirectory.fingerprints();
    }
}

