/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d;

import java.io.File;
import java.util.regex.Pattern;
import pgp.cert_d.SpecialNames;
import pgp.certificate_store.exception.BadNameException;

public class FilenameResolver {
    private final File baseDirectory;
    private final Pattern openPgpV4FingerprintPattern = Pattern.compile("^[a-f0-9]{40}$");

    public FilenameResolver(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getCertFileByFingerprint(String fingerprint) throws BadNameException {
        if (!this.isFingerprint(fingerprint)) {
            throw new BadNameException();
        }
        File subdirectory = new File(this.getBaseDirectory(), fingerprint.substring(0, 2));
        File file = new File(subdirectory, fingerprint.substring(2));
        return file;
    }

    public File getCertFileBySpecialName(String specialName) throws BadNameException {
        if (!this.isSpecialName(specialName)) {
            throw new BadNameException();
        }
        return new File(this.getBaseDirectory(), specialName);
    }

    private boolean isFingerprint(String fingerprint) {
        return this.openPgpV4FingerprintPattern.matcher(fingerprint).matches();
    }

    private boolean isSpecialName(String specialName) {
        return SpecialNames.lookupSpecialName(specialName) != null;
    }
}

