/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pgp.cert_d.BackendProvider;
import pgp.cert_d.BaseDirectoryProvider;
import pgp.cert_d.FileLockingMechanism;
import pgp.cert_d.FilenameResolver;
import pgp.cert_d.LockingMechanism;
import pgp.cert_d.SharedPGPCertificateDirectory;
import pgp.certificate_store.Certificate;
import pgp.certificate_store.CertificateReaderBackend;
import pgp.certificate_store.MergeCallback;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;
import pgp.certificate_store.exception.NotAStoreException;

public class SharedPGPCertificateDirectoryImpl
implements SharedPGPCertificateDirectory {
    private final FilenameResolver resolver;
    private final LockingMechanism writeLock;
    private final CertificateReaderBackend certificateReaderBackend;

    public SharedPGPCertificateDirectoryImpl(BackendProvider backendProvider) throws NotAStoreException {
        this(backendProvider.provideCertificateReaderBackend());
    }

    public SharedPGPCertificateDirectoryImpl(CertificateReaderBackend certificateReaderBackend) throws NotAStoreException {
        this(BaseDirectoryProvider.getDefaultBaseDir(), certificateReaderBackend);
    }

    public SharedPGPCertificateDirectoryImpl(File baseDirectory, CertificateReaderBackend certificateReaderBackend) throws NotAStoreException {
        this(certificateReaderBackend, new FilenameResolver(baseDirectory), FileLockingMechanism.defaultDirectoryFileLock(baseDirectory));
    }

    public SharedPGPCertificateDirectoryImpl(CertificateReaderBackend certificateReaderBackend, FilenameResolver filenameResolver, LockingMechanism writeLock) throws NotAStoreException {
        this.certificateReaderBackend = certificateReaderBackend;
        this.resolver = filenameResolver;
        this.writeLock = writeLock;
        File baseDirectory = this.resolver.getBaseDirectory();
        if (!baseDirectory.exists()) {
            if (!baseDirectory.mkdirs()) {
                throw new NotAStoreException("Cannot create base directory '" + this.resolver.getBaseDirectory().getAbsolutePath() + "'");
            }
        } else if (baseDirectory.isFile()) {
            throw new NotAStoreException("Base directory '" + this.resolver.getBaseDirectory().getAbsolutePath() + "' appears to be a file.");
        }
    }

    @Override
    public LockingMechanism getLock() {
        return this.writeLock;
    }

    @Override
    public Certificate getByFingerprint(String fingerprint) throws IOException, BadNameException, BadDataException {
        File certFile = this.resolver.getCertFileByFingerprint(fingerprint);
        if (!certFile.exists()) {
            return null;
        }
        FileInputStream fileIn = new FileInputStream(certFile);
        BufferedInputStream bufferedIn = new BufferedInputStream(fileIn);
        Certificate certificate = this.certificateReaderBackend.readCertificate(bufferedIn);
        if (!certificate.getFingerprint().equals(fingerprint)) {
            throw new BadDataException();
        }
        return certificate;
    }

    @Override
    public Certificate getBySpecialName(String specialName) throws IOException, BadNameException {
        File certFile = this.resolver.getCertFileBySpecialName(specialName);
        if (!certFile.exists()) {
            return null;
        }
        FileInputStream fileIn = new FileInputStream(certFile);
        BufferedInputStream bufferedIn = new BufferedInputStream(fileIn);
        Certificate certificate = this.certificateReaderBackend.readCertificate(bufferedIn);
        return certificate;
    }

    @Override
    public Certificate getByFingerprintIfChanged(String fingerprint, String tag) throws IOException, BadNameException, BadDataException {
        Certificate certificate = this.getByFingerprint(fingerprint);
        if (certificate.getTag().equals(tag)) {
            return null;
        }
        return certificate;
    }

    @Override
    public Certificate getBySpecialNameIfChanged(String specialName, String tag) throws IOException, BadNameException {
        Certificate certificate = this.getBySpecialName(specialName);
        if (certificate.getTag().equals(tag)) {
            return null;
        }
        return certificate;
    }

    @Override
    public Certificate insert(InputStream data, MergeCallback merge) throws IOException, BadDataException, InterruptedException {
        this.writeLock.lockDirectory();
        Certificate certificate = this._insert(data, merge);
        this.writeLock.releaseDirectory();
        return certificate;
    }

    @Override
    public Certificate tryInsert(InputStream data, MergeCallback merge) throws IOException, BadDataException {
        if (!this.writeLock.tryLockDirectory()) {
            return null;
        }
        Certificate certificate = this._insert(data, merge);
        this.writeLock.releaseDirectory();
        return certificate;
    }

    private Certificate _insert(InputStream data, MergeCallback merge) throws IOException, BadDataException {
        File certFile;
        Certificate existingCertificate;
        Certificate newCertificate = this.certificateReaderBackend.readCertificate(data);
        try {
            existingCertificate = this.getByFingerprint(newCertificate.getFingerprint());
            certFile = this.resolver.getCertFileByFingerprint(newCertificate.getFingerprint());
        }
        catch (BadNameException e) {
            throw new BadDataException();
        }
        if (existingCertificate != null && !existingCertificate.getTag().equals(newCertificate.getTag())) {
            newCertificate = merge.merge(newCertificate, existingCertificate);
        }
        this.writeCertificate(newCertificate, certFile);
        return newCertificate;
    }

    private void writeCertificate(Certificate certificate, File certFile) throws IOException {
        int read;
        certFile.getParentFile().mkdirs();
        if (!certFile.exists() && !certFile.createNewFile()) {
            throw new IOException("Could not create cert file " + certFile.getAbsolutePath());
        }
        InputStream certIn = certificate.getInputStream();
        FileOutputStream fileOut = new FileOutputStream(certFile);
        byte[] buffer = new byte[4096];
        while ((read = certIn.read(buffer)) != -1) {
            fileOut.write(buffer, 0, read);
        }
        certIn.close();
        fileOut.close();
    }

    @Override
    public Certificate insertWithSpecialName(String specialName, InputStream data, MergeCallback merge) throws IOException, BadNameException, BadDataException, InterruptedException {
        this.writeLock.lockDirectory();
        Certificate certificate = this._insertSpecial(specialName, data, merge);
        this.writeLock.releaseDirectory();
        return certificate;
    }

    @Override
    public Certificate tryInsertWithSpecialName(String specialName, InputStream data, MergeCallback merge) throws IOException, BadNameException, BadDataException {
        if (!this.writeLock.tryLockDirectory()) {
            return null;
        }
        Certificate certificate = this._insertSpecial(specialName, data, merge);
        this.writeLock.releaseDirectory();
        return certificate;
    }

    private Certificate _insertSpecial(String specialName, InputStream data, MergeCallback merge) throws IOException, BadNameException, BadDataException {
        Certificate newCertificate = this.certificateReaderBackend.readCertificate(data);
        Certificate existingCertificate = this.getBySpecialName(specialName);
        File certFile = this.resolver.getCertFileBySpecialName(specialName);
        if (existingCertificate != null && !existingCertificate.getTag().equals(newCertificate.getTag())) {
            newCertificate = merge.merge(newCertificate, existingCertificate);
        }
        this.writeCertificate(newCertificate, certFile);
        return newCertificate;
    }

    @Override
    public Iterator<Certificate> items() {
        return new Iterator<Certificate>(){
            private final List<Lazy<Certificate>> certificateQueue = Collections.synchronizedList(new ArrayList());
            {
                File[] subdirectories;
                for (final File subdirectory : subdirectories = SharedPGPCertificateDirectoryImpl.this.resolver.getBaseDirectory().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().matches("^[a-f0-9]{2}$");
                    }
                })) {
                    File[] files;
                    for (final File certFile : files = subdirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isFile() && file.getName().matches("^[a-f0-9]{38}$");
                        }
                    })) {
                        this.certificateQueue.add(new Lazy<Certificate>(){

                            @Override
                            Certificate get() throws BadDataException {
                                try {
                                    Certificate certificate = SharedPGPCertificateDirectoryImpl.this.certificateReaderBackend.readCertificate(new FileInputStream(certFile));
                                    if (!(subdirectory.getName() + certFile.getName()).equals(certificate.getFingerprint())) {
                                        throw new BadDataException();
                                    }
                                    return certificate;
                                }
                                catch (IOException e) {
                                    throw new AssertionError((Object)"File got deleted.");
                                }
                            }
                        });
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return !this.certificateQueue.isEmpty();
            }

            @Override
            public Certificate next() {
                try {
                    return this.certificateQueue.remove(0).get();
                }
                catch (BadDataException e) {
                    throw new AssertionError((Object)("Could not retrieve item: " + e.getMessage()));
                }
            }
        };
    }

    @Override
    public Iterator<String> fingerprints() {
        final Iterator<Certificate> certificates = this.items();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return certificates.hasNext();
            }

            @Override
            public String next() {
                return ((Certificate)certificates.next()).getFingerprint();
            }
        };
    }

    private static abstract class Lazy<E> {
        private Lazy() {
        }

        abstract E get() throws BadDataException;
    }
}

