/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.jdbc.sqlite;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;
import pgp.cert_d.jdbc.sqlite.Entry;
import pgp.cert_d.jdbc.sqlite.SubkeyLookupDao;

public class SqliteSubkeyLookupDaoImpl
implements SubkeyLookupDao {
    private final String databaseUrl;
    private static final String CREATE_TABLE_STMT = "CREATE TABLE IF NOT EXISTS subkey_lookup (\n  id integer PRIMARY KEY,\n  certificate text NOT NULL,\n  subkey_id integer NOT NULL,\n  UNIQUE(certificate, subkey_id)\n)";
    private static final String INSERT_STMT = "INSERT INTO subkey_lookup(certificate, subkey_id) VALUES (?,?)";
    private static final String QUERY_STMT = "SELECT * FROM subkey_lookup WHERE subkey_id=?";

    public SqliteSubkeyLookupDaoImpl(String databaseURL) throws SQLException {
        this.databaseUrl = databaseURL;
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(CREATE_TABLE_STMT);
        }
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.databaseUrl);
    }

    public static SqliteSubkeyLookupDaoImpl forDatabaseFile(File databaseFile) throws SQLException {
        return new SqliteSubkeyLookupDaoImpl("jdbc:sqlite:" + databaseFile.getAbsolutePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int insertValues(String certificate, List<Long> subkeyIds) throws SQLException {
        int inserted = 0;
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(INSERT_STMT);){
            for (long subkeyId : subkeyIds) {
                try {
                    statement.setString(1, certificate);
                    statement.setLong(2, subkeyId);
                    statement.executeUpdate();
                    ++inserted;
                }
                catch (SQLiteException e) {
                    if (e.getResultCode().code == SQLiteErrorCode.SQLITE_CONSTRAINT_UNIQUE.code) continue;
                    throw e;
                    return inserted;
                }
            }
        }
    }

    @Override
    public List<Entry> selectValues(long subkeyId) throws SQLException {
        ArrayList<Entry> results = new ArrayList<Entry>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(QUERY_STMT);){
            statement.setLong(1, subkeyId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    Entry entry = new Entry(resultSet.getInt("id"), resultSet.getLong("subkey_id"), resultSet.getString("certificate"));
                    results.add(entry);
                }
            }
        }
        return results;
    }
}

