/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.pgpainless.implementation.ImplementationFactory;

public class OpenPgpInputStream
extends BufferedInputStream {
    private static final byte[] ARMOR_HEADER = "-----BEGIN PGP ".getBytes(Charset.forName("UTF8"));
    public static final int MAX_BUFFER_SIZE = 16384;
    private final byte[] buffer;
    private final int bufferLen;
    private boolean containsArmorHeader;
    private boolean containsOpenPgpPackets;

    public OpenPgpInputStream(InputStream in) throws IOException {
        super(in, 16384);
        this.mark(16384);
        this.buffer = new byte[16384];
        this.bufferLen = this.read(this.buffer);
        this.reset();
        this.inspectBuffer();
    }

    private void inspectBuffer() {
        if (this.determineIsArmored()) {
            return;
        }
        this.determineIsBinaryOpenPgp();
    }

    private boolean determineIsArmored() {
        if (this.startsWithIgnoringWhitespace(this.buffer, ARMOR_HEADER, this.bufferLen)) {
            this.containsArmorHeader = true;
            return true;
        }
        return false;
    }

    private void determineIsBinaryOpenPgp() {
        if (this.bufferLen == -1) {
            return;
        }
        try {
            ByteArrayInputStream bufferIn = new ByteArrayInputStream(this.buffer, 0, this.bufferLen);
            PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(bufferIn);
            boolean containsPackets = false;
            while (objectFactory.nextObject() != null) {
                containsPackets = true;
            }
            this.containsOpenPgpPackets = containsPackets;
        }
        catch (IOException e) {
            String msg = e.getMessage();
            this.containsOpenPgpPackets = msg != null && msg.contains("premature end of stream in PartialInputStream");
        }
    }

    private boolean startsWithIgnoringWhitespace(byte[] bytes, byte[] subsequence, int bufferLen) {
        if (bufferLen == -1) {
            return false;
        }
        for (int i = 0; i < bufferLen; ++i) {
            if (Character.isWhitespace(bytes[i])) continue;
            if (i + subsequence.length > bytes.length) {
                return false;
            }
            for (int j = 0; j < subsequence.length; ++j) {
                if (bytes[i + j] == subsequence[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isAsciiArmored() {
        return this.containsArmorHeader;
    }

    public boolean isBinaryOpenPgp() {
        return this.containsOpenPgpPackets;
    }

    public boolean isNonOpenPgp() {
        return !this.isAsciiArmored() && !this.isBinaryOpenPgp();
    }
}

