/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import pgp.cert_d.LockingMechanism;

public class FileLockingMechanism
implements LockingMechanism {
    private final File lockFile;
    private RandomAccessFile randomAccessFile;
    private FileLock fileLock;

    public FileLockingMechanism(File lockFile) {
        this.lockFile = lockFile;
    }

    public static FileLockingMechanism defaultDirectoryFileLock(File baseDirectory) {
        return new FileLockingMechanism(new File(baseDirectory, "writelock"));
    }

    @Override
    public synchronized void lockDirectory() throws IOException, InterruptedException {
        if (this.randomAccessFile != null) {
            this.wait();
        }
        try {
            this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
        }
        catch (FileNotFoundException e) {
            this.lockFile.createNewFile();
            this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
        }
        this.fileLock = this.randomAccessFile.getChannel().lock();
    }

    @Override
    public synchronized boolean tryLockDirectory() throws IOException {
        if (this.randomAccessFile != null) {
            return false;
        }
        try {
            this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
        }
        catch (FileNotFoundException e) {
            this.lockFile.createNewFile();
            this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
        }
        try {
            this.fileLock = this.randomAccessFile.getChannel().tryLock();
            if (this.fileLock == null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
                return false;
            }
        }
        catch (OverlappingFileLockException e) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void releaseDirectory() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
            this.fileLock = null;
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        if (this.lockFile.exists()) {
            this.lockFile.delete();
        }
        this.notify();
    }
}

