/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli;

import java.io.File;
import java.sql.SQLException;
import org.pgpainless.certificate_store.CertificateReader;
import org.pgpainless.certificate_store.SharedPGPCertificateDirectoryAdapter;
import pgp.cert_d.BaseDirectoryProvider;
import pgp.cert_d.SharedPGPCertificateDirectoryImpl;
import pgp.cert_d.cli.commands.Get;
import pgp.cert_d.cli.commands.Import;
import pgp.cert_d.cli.commands.MultiImport;
import pgp.cert_d.jdbc.sqlite.DatabaseSubkeyLookup;
import pgp.cert_d.jdbc.sqlite.SqliteSubkeyLookupDaoImpl;
import pgp.certificate_store.CertificateDirectory;
import pgp.certificate_store.exception.NotAStoreException;
import picocli.CommandLine;

@CommandLine.Command(name="certificate-store", description={"Store and manage public OpenPGP certificates"}, subcommands={Import.class, MultiImport.class, Get.class})
public class PGPCertDCli {
    @CommandLine.Option(names={"--base-directory"}, paramLabel="DIRECTORY", description={"Overwrite the default certificate directory"})
    File baseDirectory;
    private static CertificateDirectory certificateDirectory;

    private int executionStrategy(CommandLine.ParseResult parseResult) {
        try {
            this.initStore();
        }
        catch (SQLException | NotAStoreException e) {
            return -1;
        }
        return new CommandLine.RunLast().execute(parseResult);
    }

    private void initStore() throws NotAStoreException, SQLException {
        if (this.baseDirectory == null) {
            this.baseDirectory = BaseDirectoryProvider.getDefaultBaseDir();
        }
        SharedPGPCertificateDirectoryImpl certificateDirectory = new SharedPGPCertificateDirectoryImpl(this.baseDirectory, new CertificateReader());
        DatabaseSubkeyLookup subkeyLookup = new DatabaseSubkeyLookup(SqliteSubkeyLookupDaoImpl.forDatabaseFile(new File(this.baseDirectory, "_pgpainless_subkey_map.db")));
        PGPCertDCli.certificateDirectory = new SharedPGPCertificateDirectoryAdapter(certificateDirectory, subkeyLookup);
    }

    public static void main(String[] args) {
        PGPCertDCli cli = new PGPCertDCli();
        new CommandLine(cli).setExecutionStrategy(parserResult -> cli.executionStrategy(parserResult)).execute(args);
    }

    public static CertificateDirectory getCertificateDirectory() {
        return certificateDirectory;
    }
}

