/*
 * Decompiled with CFR 0.152.
 */
package pgp.certificate_store;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.certificate_store.Certificate;
import pgp.certificate_store.CertificateStore;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;

public abstract class AbstractCertificateStore
implements CertificateStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCertificateStore.class);

    public Set<Certificate> getCertificatesBySubkeyId(long subkeyId) throws IOException {
        Set<String> identifiers = this.getCertificateFingerprintsForSubkeyId(subkeyId);
        if (identifiers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Certificate> certificates = new HashSet<Certificate>();
        for (String identifier : identifiers) {
            try {
                certificates.add(this.getCertificate(identifier));
            }
            catch (BadDataException | BadNameException e) {
                LOGGER.warn("Could not read certificate.", e);
            }
        }
        return certificates;
    }
}

