/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.decryption_verification.CloseForResultInputStream;
import org.pgpainless.decryption_verification.IntegrityProtectedInputStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public class DecryptionStream
extends CloseForResultInputStream {
    private final InputStream inputStream;
    private final IntegrityProtectedInputStream integrityProtectedInputStream;
    private final InputStream armorStream;

    DecryptionStream(@Nonnull InputStream wrapped, @Nonnull OpenPgpMetadata.Builder resultBuilder, IntegrityProtectedInputStream integrityProtectedInputStream, InputStream armorStream) {
        super(resultBuilder);
        this.inputStream = wrapped;
        this.integrityProtectedInputStream = integrityProtectedInputStream;
        this.armorStream = armorStream;
    }

    @Override
    public void close() throws IOException {
        if (this.armorStream != null) {
            Streams.drain(this.armorStream);
        }
        this.inputStream.close();
        if (this.integrityProtectedInputStream != null) {
            this.integrityProtectedInputStream.close();
        }
        super.close();
    }

    @Override
    public int read() throws IOException {
        int r = this.inputStream.read();
        return r;
    }

    @Override
    public int read(@Nonnull byte[] bytes, int offset, int length) throws IOException {
        int read = this.inputStream.read(bytes, offset, length);
        return read;
    }
}

