/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.CRLFGeneratorStream;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SignatureGenerationStream;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptionStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionStream.class);
    private final ProducerOptions options;
    private final EncryptionResult.Builder resultBuilder = EncryptionResult.builder();
    private boolean closed = false;
    private static final int BUFFER_SIZE = 512;
    OutputStream outermostStream;
    OutputStream signatureLayerStream;
    private ArmoredOutputStream armorOutputStream = null;
    private OutputStream publicKeyEncryptedStream = null;
    private PGPCompressedDataGenerator compressedDataGenerator;
    private BCPGOutputStream basicCompressionStream;
    private PGPLiteralDataGenerator literalDataGenerator;
    private OutputStream literalDataStream;

    EncryptionStream(@Nonnull OutputStream targetOutputStream, @Nonnull ProducerOptions options) throws IOException, PGPException {
        this.options = options;
        this.outermostStream = targetOutputStream;
        this.prepareArmor();
        this.prepareEncryption();
        this.prepareCompression();
        this.prepareOnePassSignatures();
        this.prepareLiteralDataProcessing();
        this.prepareSigningStream();
        this.prepareInputEncoding();
    }

    private void prepareArmor() {
        if (!this.options.isAsciiArmor()) {
            LOGGER.debug("Output will be unarmored");
            return;
        }
        this.outermostStream = new BufferedOutputStream(this.outermostStream);
        LOGGER.debug("Wrap encryption output in ASCII armor");
        this.armorOutputStream = ArmoredOutputStreamFactory.get(this.outermostStream, this.options);
        if (this.options.hasComment()) {
            String[] commentLines;
            for (String commentLine : commentLines = this.options.getComment().split("\n")) {
                if (commentLine.trim().isEmpty()) continue;
                ArmorUtils.addCommentHeader(this.armorOutputStream, commentLine.trim());
            }
        }
        this.outermostStream = this.armorOutputStream;
    }

    private void prepareEncryption() throws IOException, PGPException {
        EncryptionOptions encryptionOptions = this.options.getEncryptionOptions();
        if (encryptionOptions == null || encryptionOptions.getEncryptionMethods().isEmpty()) {
            this.resultBuilder.setEncryptionAlgorithm(SymmetricKeyAlgorithm.NULL);
            return;
        }
        SymmetricKeyAlgorithm encryptionAlgorithm = EncryptionBuilder.negotiateSymmetricEncryptionAlgorithm(encryptionOptions);
        this.resultBuilder.setEncryptionAlgorithm(encryptionAlgorithm);
        LOGGER.debug("Encrypt message using {}", (Object)encryptionAlgorithm);
        PGPDataEncryptorBuilder dataEncryptorBuilder = ImplementationFactory.getInstance().getPGPDataEncryptorBuilder(encryptionAlgorithm);
        dataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptorBuilder);
        for (PGPKeyEncryptionMethodGenerator encryptionMethod : encryptionOptions.getEncryptionMethods()) {
            encryptedDataGenerator.addMethod(encryptionMethod);
        }
        for (SubkeyIdentifier recipientSubkeyIdentifier : encryptionOptions.getEncryptionKeyIdentifiers()) {
            this.resultBuilder.addRecipient(recipientSubkeyIdentifier);
        }
        this.outermostStream = this.publicKeyEncryptedStream = encryptedDataGenerator.open(this.outermostStream, new byte[512]);
    }

    private void prepareCompression() throws IOException {
        CompressionAlgorithm compressionAlgorithm = EncryptionBuilder.negotiateCompressionAlgorithm(this.options);
        this.resultBuilder.setCompressionAlgorithm(compressionAlgorithm);
        this.compressedDataGenerator = new PGPCompressedDataGenerator(compressionAlgorithm.getAlgorithmId());
        if (compressionAlgorithm == CompressionAlgorithm.UNCOMPRESSED) {
            return;
        }
        LOGGER.debug("Compress using {}", (Object)compressionAlgorithm);
        this.basicCompressionStream = new BCPGOutputStream(this.compressedDataGenerator.open(this.outermostStream));
        this.outermostStream = this.basicCompressionStream;
    }

    private void prepareOnePassSignatures() throws IOException, PGPException {
        this.signatureLayerStream = this.outermostStream;
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        int sigIndex = 0;
        for (SubkeyIdentifier identifier : signingOptions.getSigningMethods().keySet()) {
            ++sigIndex;
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(identifier);
            if (signingMethod.isDetached()) continue;
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            boolean nested = sigIndex != signingOptions.getSigningMethods().size();
            signatureGenerator.generateOnePassVersion(nested).encode(this.outermostStream);
        }
    }

    private void prepareLiteralDataProcessing() throws IOException {
        if (this.options.isCleartextSigned()) {
            SigningOptions.SigningMethod firstMethod = this.options.getSigningOptions().getSigningMethods().values().iterator().next();
            this.armorOutputStream.beginClearText(firstMethod.getHashAlgorithm().getAlgorithmId());
            return;
        }
        this.literalDataGenerator = new PGPLiteralDataGenerator();
        this.outermostStream = this.literalDataStream = this.literalDataGenerator.open(this.outermostStream, this.options.getEncoding().getCode(), this.options.getFileName(), this.options.getModificationDate(), new byte[512]);
        this.resultBuilder.setFileName(this.options.getFileName()).setModificationDate(this.options.getModificationDate()).setFileEncoding(this.options.getEncoding());
    }

    public void prepareSigningStream() {
        this.outermostStream = new SignatureGenerationStream(this.outermostStream, this.options.getSigningOptions());
    }

    public void prepareInputEncoding() {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.outermostStream);
        CRLFGeneratorStream crlfGeneratorStream = new CRLFGeneratorStream(bufferedOutputStream, this.options.isApplyCRLFEncoding() ? StreamEncoding.UTF8 : StreamEncoding.BINARY);
        this.outermostStream = crlfGeneratorStream;
    }

    @Override
    public void write(int data) throws IOException {
        this.outermostStream.write(data);
    }

    @Override
    public void write(@Nonnull byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(@Nonnull byte[] buffer, int off, int len) throws IOException {
        this.outermostStream.write(buffer, 0, len);
    }

    @Override
    public void flush() throws IOException {
        this.outermostStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.outermostStream.close();
        if (this.literalDataStream != null) {
            this.literalDataStream.flush();
            this.literalDataStream.close();
        }
        if (this.literalDataGenerator != null) {
            this.literalDataGenerator.close();
        }
        if (this.options.isCleartextSigned()) {
            this.armorOutputStream.write(13);
            this.armorOutputStream.write(10);
            this.armorOutputStream.endClearText();
        }
        try {
            this.writeSignatures();
        }
        catch (PGPException e) {
            throw new IOException("Exception while writing signatures.", e);
        }
        this.compressedDataGenerator.close();
        if (this.publicKeyEncryptedStream != null) {
            this.publicKeyEncryptedStream.flush();
            this.publicKeyEncryptedStream.close();
        }
        if (this.armorOutputStream != null) {
            this.armorOutputStream.flush();
            this.armorOutputStream.close();
        }
        this.closed = true;
    }

    private void writeSignatures() throws PGPException, IOException {
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        ArrayList<SubkeyIdentifier> signingKeys = new ArrayList<SubkeyIdentifier>(signingOptions.getSigningMethods().keySet());
        for (int i = signingKeys.size() - 1; i >= 0; --i) {
            SubkeyIdentifier signingKey = (SubkeyIdentifier)signingKeys.get(i);
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            PGPSignature signature = signatureGenerator.generate();
            if (signingMethod.isDetached()) {
                this.resultBuilder.addDetachedSignature(signingKey, signature);
            }
            if (signingMethod.isDetached() && !this.options.isCleartextSigned()) continue;
            signature.encode(this.signatureLayerStream);
        }
    }

    public EncryptionResult getResult() {
        if (!this.closed) {
            throw new IllegalStateException("EncryptionStream must be closed before accessing the Result.");
        }
        return this.resultBuilder.build();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

