/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.ecc.ecdsa;

import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.Nonnull;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;

public final class ECDSA
implements KeyType {
    private final EllipticCurve curve;

    private ECDSA(@Nonnull EllipticCurve curve) {
        this.curve = curve;
    }

    public static ECDSA fromCurve(@Nonnull EllipticCurve curve) {
        return new ECDSA(curve);
    }

    @Override
    public String getName() {
        return "ECDSA";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.ECDSA;
    }

    @Override
    public int getBitStrength() {
        return this.curve.getBitStrength();
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new ECNamedCurveGenParameterSpec(this.curve.getName());
    }
}

