/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import pgp.cert_d.PGPCertificateDirectory;
import pgp.cert_d.SpecialNames;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.certificate.Key;
import pgp.certificate_store.certificate.KeyMaterial;
import pgp.certificate_store.certificate.KeyMaterialMerger;
import pgp.certificate_store.certificate.KeyMaterialReaderBackend;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;

public class InMemoryCertificateDirectoryBackend
implements PGPCertificateDirectory.Backend {
    private final Map<String, Certificate> certificateFingerprintMap = new HashMap<String, Certificate>();
    private final Map<String, KeyMaterial> keyMaterialSpecialNameMap = new HashMap<String, KeyMaterial>();
    private final PGPCertificateDirectory.LockingMechanism lock = new ObjectLockingMechanism();
    private final KeyMaterialReaderBackend reader;
    private final AtomicLong nonce = new AtomicLong(1L);

    public InMemoryCertificateDirectoryBackend(KeyMaterialReaderBackend reader) {
        this.reader = reader;
    }

    @Override
    public PGPCertificateDirectory.LockingMechanism getLock() {
        return this.lock;
    }

    @Override
    public Certificate readByFingerprint(String fingerprint) {
        return this.certificateFingerprintMap.get(fingerprint);
    }

    @Override
    public KeyMaterial readBySpecialName(String specialName) throws BadNameException {
        if (SpecialNames.lookupSpecialName(specialName) == null) {
            throw new BadNameException("Invalid special name " + specialName);
        }
        return this.keyMaterialSpecialNameMap.get(specialName);
    }

    @Override
    public Iterator<Certificate> readItems() {
        return this.certificateFingerprintMap.values().iterator();
    }

    @Override
    public KeyMaterial doInsertTrustRoot(InputStream data, KeyMaterialMerger merge) throws BadDataException, IOException {
        KeyMaterial update = this.reader.read(data, null);
        KeyMaterial existing = null;
        try {
            existing = this.readBySpecialName("trust-root");
        }
        catch (BadNameException e) {
            throw new RuntimeException(e);
        }
        KeyMaterial merged = merge.merge(update, existing);
        merged = merged instanceof Key ? new Key((Key)merged, this.newTag()) : new Certificate((Certificate)merged, this.newTag());
        this.keyMaterialSpecialNameMap.put("trust-root", merged);
        return merged;
    }

    @Override
    public Certificate doInsert(InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException {
        KeyMaterial update = this.reader.read(data, null);
        Certificate existing = this.readByFingerprint(update.getFingerprint());
        Certificate merged = merge.merge(update, existing).asCertificate();
        merged = new Certificate(merged, this.newTag());
        this.certificateFingerprintMap.put(update.getFingerprint(), merged);
        return merged;
    }

    @Override
    public Certificate doInsertWithSpecialName(String specialName, InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException, BadNameException {
        KeyMaterial existing;
        KeyMaterial keyMaterial = this.reader.read(data, null);
        KeyMaterial merged = merge.merge(keyMaterial, existing = this.readBySpecialName(specialName));
        merged = merged instanceof Key ? new Key((Key)merged, this.newTag()) : new Certificate((Certificate)merged, this.newTag());
        this.keyMaterialSpecialNameMap.put(specialName, merged);
        return merged.asCertificate();
    }

    @Override
    public Long getTagForFingerprint(String fingerprint) throws BadNameException, IOException {
        Certificate certificate = this.certificateFingerprintMap.get(fingerprint);
        if (certificate == null) {
            return null;
        }
        return certificate.getTag();
    }

    @Override
    public Long getTagForSpecialName(String specialName) throws BadNameException, IOException {
        if (SpecialNames.lookupSpecialName(specialName) == null) {
            throw new BadNameException("Invalid special name " + specialName);
        }
        KeyMaterial tagged = this.keyMaterialSpecialNameMap.get(specialName);
        if (tagged == null) {
            return null;
        }
        return tagged.getTag();
    }

    private Long newTag() {
        return System.currentTimeMillis() + this.nonce.incrementAndGet();
    }

    protected static class ObjectLockingMechanism
    implements PGPCertificateDirectory.LockingMechanism {
        private boolean locked = false;

        protected ObjectLockingMechanism() {
        }

        @Override
        public synchronized void lockDirectory() throws InterruptedException {
            if (this.isLocked()) {
                this.wait();
            }
            this.locked = true;
        }

        @Override
        public synchronized boolean tryLockDirectory() {
            if (this.isLocked()) {
                return false;
            }
            this.locked = true;
            return true;
        }

        @Override
        public synchronized boolean isLocked() {
            return this.locked;
        }

        @Override
        public synchronized void releaseDirectory() {
            this.locked = false;
            this.notify();
        }
    }
}

