/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli;

import java.io.File;
import java.sql.SQLException;
import org.pgpainless.certificate_store.PGPainlessCertD;
import pgp.cert_d.BaseDirectoryProvider;
import pgp.cert_d.cli.commands.Export;
import pgp.cert_d.cli.commands.Find;
import pgp.cert_d.cli.commands.Get;
import pgp.cert_d.cli.commands.Import;
import pgp.cert_d.cli.commands.Insert;
import pgp.cert_d.cli.commands.List;
import pgp.cert_d.cli.commands.Setup;
import pgp.cert_d.jdbc.sqlite.DatabaseSubkeyLookupFactory;
import pgp.certificate_store.exception.NotAStoreException;
import picocli.CommandLine;

@CommandLine.Command(name="certificate-store", resourceBundle="msg_pgp-cert-d", subcommands={CommandLine.HelpCommand.class, Export.class, Insert.class, Import.class, Get.class, Setup.class, List.class, Find.class})
public class PGPCertDCli {
    @CommandLine.Option(names={"-s", "--store"}, paramLabel="DIRECTORY", scope=CommandLine.ScopeType.INHERIT)
    File baseDirectory;
    static PGPainlessCertD certificateDirectory;
    public static final int EXIT_CODE_NOT_A_STORE = 30;

    private int executionStrategy(CommandLine.ParseResult parseResult) {
        try {
            this.initStore();
        }
        catch (SQLException | NotAStoreException e) {
            return 30;
        }
        return new CommandLine.RunLast().execute(parseResult);
    }

    private void initStore() throws NotAStoreException, SQLException {
        if (certificateDirectory != null) {
            return;
        }
        if (this.baseDirectory == null) {
            this.baseDirectory = BaseDirectoryProvider.getDefaultBaseDir();
        }
        certificateDirectory = PGPainlessCertD.fileBased(this.baseDirectory, new DatabaseSubkeyLookupFactory());
    }

    public static void main(String[] args) {
        PGPCertDCli cli = new PGPCertDCli();
        new CommandLine(cli).setExecutionStrategy(parserResult -> cli.executionStrategy(parserResult)).execute(args);
    }

    public static PGPainlessCertD getCertificateDirectory() {
        return certificateDirectory;
    }
}

