/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli.commands;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.util.ArmorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.cert_d.SpecialNames;
import pgp.cert_d.cli.PGPCertDCli;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;
import picocli.CommandLine;

@CommandLine.Command(name="get", resourceBundle="msg_get")
public class Get
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Get.class);
    public static final int EXIT_CODE_NO_SUCH_ELEMENT = 2;
    public static final int EXIT_CODE_IO_ERROR = 5;
    @CommandLine.Option(names={"-a", "--armor"})
    boolean armor = false;
    @CommandLine.Parameters(paramLabel="IDENTIFIER", arity="1")
    String identifier;

    @Override
    public void run() {
        try {
            Certificate record = SpecialNames.lookupSpecialName(this.identifier) != null ? PGPCertDCli.getCertificateDirectory().getBySpecialName(this.identifier) : PGPCertDCli.getCertificateDirectory().getByFingerprint(this.identifier.toLowerCase());
            if (record == null) {
                return;
            }
            if (this.armor) {
                PGPKeyRing keyRing = PGPainless.readKeyRing().keyRing(record.getInputStream());
                ArmoredOutputStream armorOut = ArmorUtils.toAsciiArmoredStream(keyRing, System.out);
                Streams.pipeAll(record.getInputStream(), armorOut);
                armorOut.close();
            } else {
                Streams.pipeAll(record.getInputStream(), System.out);
            }
        }
        catch (NoSuchElementException e) {
            LOGGER.debug("Certificate not found.", e);
            System.exit(2);
        }
        catch (IOException e) {
            LOGGER.error("IO Error", e);
            System.exit(5);
        }
        catch (BadDataException e) {
            LOGGER.error("Certificate file contains bad data.", e);
            System.exit(-1);
        }
        catch (BadNameException e) {
            LOGGER.error("Certificate fingerprint mismatch.", e);
            System.exit(-1);
        }
    }
}

