/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.jdbc.sqlite;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import pgp.cert_d.jdbc.sqlite.DatabaseSubkeyLookup;
import pgp.cert_d.jdbc.sqlite.SqliteSubkeyLookupDaoImpl;
import pgp.cert_d.subkey_lookup.SubkeyLookup;
import pgp.cert_d.subkey_lookup.SubkeyLookupFactory;

public class DatabaseSubkeyLookupFactory
implements SubkeyLookupFactory {
    private String databaseName;

    public DatabaseSubkeyLookupFactory() {
        this("_pgpainless_subkey_map.db");
    }

    public DatabaseSubkeyLookupFactory(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public SubkeyLookup createFileBasedInstance(File baseDirectory) {
        SqliteSubkeyLookupDaoImpl dao;
        File databaseFile = new File(baseDirectory, this.databaseName);
        try {
            if (!databaseFile.exists()) {
                databaseFile.createNewFile();
            }
            dao = SqliteSubkeyLookupDaoImpl.forDatabaseFile(databaseFile);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        return new DatabaseSubkeyLookup(dao);
    }
}

