/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.cert_d.cli.PGPCertDCli;
import pgp.certificate_store.certificate.Certificate;
import picocli.CommandLine;

@CommandLine.Command(name="export", resourceBundle="msg_export")
public class Export
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Export.class);
    @CommandLine.Option(names={"-a", "--armor"})
    boolean armor = false;

    @Override
    public void run() {
        PrintStream out;
        Iterator certificates = PGPCertDCli.getCertificateDirectory().items();
        PrintStream printStream = out = this.armor ? new ArmoredOutputStream((OutputStream)System.out) : System.out;
        while (certificates.hasNext()) {
            try {
                Certificate certificate = (Certificate)certificates.next();
                InputStream inputStream = certificate.getInputStream();
                Streams.pipeAll((InputStream)inputStream, (OutputStream)out);
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("IO Error", (Throwable)e);
                System.exit(-1);
            }
        }
        if (this.armor) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

