/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli.commands;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Set;
import java.util.regex.Pattern;
import org.pgpainless.key.OpenPgpFingerprint;
import pgp.cert_d.cli.PGPCertDCli;
import picocli.CommandLine;

@CommandLine.Command(name="find", resourceBundle="msg_find")
public class Find
implements Runnable {
    private static final Pattern LONG_KEY_ID = Pattern.compile("^[0-9A-Fa-f]{16}$");
    @CommandLine.Parameters(paramLabel="IDENTIFIER", arity="1")
    String identifier;

    @Override
    public void run() {
        long subkeyId;
        if (this.identifier == null) {
            throw new IllegalArgumentException("No subkey ID provided.");
        }
        this.identifier = this.identifier.trim();
        try {
            OpenPgpFingerprint fingerprint = OpenPgpFingerprint.parse((String)this.identifier);
            subkeyId = fingerprint.getKeyId();
        }
        catch (IllegalArgumentException e) {
            if (!LONG_KEY_ID.matcher(this.identifier).matches()) {
                throw new IllegalArgumentException("Provided long key-id does not match expected format. A long key-id consists of 16 hexadecimal characters.");
            }
            subkeyId = new BigInteger(this.identifier, 16).longValue();
        }
        try {
            Set fingerprints = PGPCertDCli.getCertificateDirectory().getCertificateFingerprintsForSubkeyId(subkeyId);
            for (String fingerprint : fingerprints) {
                System.out.println(fingerprint);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

