/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.cert_d.SpecialNames;
import pgp.cert_d.cli.PGPCertDCli;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;
import picocli.CommandLine;

@CommandLine.Command(name="get", resourceBundle="msg_get")
public class Get
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Get.class);
    public static final int EXIT_CODE_NO_SUCH_ELEMENT = 2;
    public static final int EXIT_CODE_IO_ERROR = 5;
    @CommandLine.Option(names={"-a", "--armor"})
    boolean armor = false;
    @CommandLine.Parameters(paramLabel="IDENTIFIER", arity="1")
    String identifier;

    @Override
    public void run() {
        try {
            Certificate record = SpecialNames.lookupSpecialName((String)this.identifier) != null ? PGPCertDCli.getCertificateDirectory().getBySpecialName(this.identifier) : PGPCertDCli.getCertificateDirectory().getByFingerprint(this.identifier.toLowerCase());
            if (record == null) {
                return;
            }
            if (this.armor) {
                OpenPGPCertificate certOrKey = PGPainless.getInstance().readKey().parseCertificateOrKey(record.getInputStream());
                System.out.println(certOrKey.toAsciiArmoredString());
            } else {
                Streams.pipeAll((InputStream)record.getInputStream(), (OutputStream)System.out);
            }
        }
        catch (NoSuchElementException e) {
            LOGGER.debug("Certificate not found.", (Throwable)e);
            System.exit(2);
        }
        catch (IOException e) {
            LOGGER.error("IO Error", (Throwable)e);
            System.exit(5);
        }
        catch (BadDataException e) {
            LOGGER.error("Certificate file contains bad data.", (Throwable)e);
            System.exit(-1);
        }
        catch (BadNameException e) {
            LOGGER.error("Certificate fingerprint mismatch.", (Throwable)e);
            System.exit(-1);
        }
    }
}

