/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.pgpainless.PGPainless;
import org.pgpainless.certificate_store.MergeCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.cert_d.cli.PGPCertDCli;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.exception.BadDataException;
import picocli.CommandLine;

@CommandLine.Command(name="import", resourceBundle="msg_import")
public class Import
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Import.class);

    @Override
    public void run() {
        try {
            List certsOrKeys = PGPainless.getInstance().readKey().parseKeysOrCertificates(System.in);
            for (OpenPGPCertificate toInsert : certsOrKeys) {
                try {
                    Certificate inserted = PGPCertDCli.getCertificateDirectory().insert((InputStream)new ByteArrayInputStream(toInsert.getEncoded()), MergeCallbacks.mergeWithExisting());
                    LOGGER.info(inserted.getFingerprint());
                }
                catch (BadDataException e) {
                    LOGGER.error("Certificate " + String.valueOf(toInsert.getKeyIdentifier()) + " contains bad data.", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("IO error importing certificate " + String.valueOf(toInsert.getKeyIdentifier()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Thread interrupted while importing certificate " + String.valueOf(toInsert.getKeyIdentifier()), (Throwable)e);
                    System.exit(1);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IO-Error.", (Throwable)e);
            System.exit(1);
        }
    }
}

