/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.cli.commands;

import java.io.IOException;
import org.pgpainless.certificate_store.MergeCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.cert_d.cli.PGPCertDCli;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.exception.BadDataException;
import picocli.CommandLine;

@CommandLine.Command(name="insert", resourceBundle="msg_insert")
public class Insert
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Insert.class);

    @Override
    public void run() {
        try {
            Certificate certificate = PGPCertDCli.getCertificateDirectory().insert(System.in, MergeCallbacks.mergeWithExisting());
            System.out.println(certificate.getFingerprint());
        }
        catch (IOException e) {
            LOGGER.error("IO-Error.", (Throwable)e);
            System.exit(-1);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted.", (Throwable)e);
            System.exit(-1);
        }
        catch (BadDataException e) {
            LOGGER.error("Certificate contains bad data.", (Throwable)e);
            System.exit(-1);
        }
    }
}

