/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cert_d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.certificate_store.CertificateReader;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import pgp.cert_d.CachingSharedPGPCertificateDirectoryWrapper;
import pgp.cert_d.FileLockingMechanism;
import pgp.cert_d.SharedPGPCertificateDirectory;
import pgp.cert_d.SharedPGPCertificateDirectoryImpl;
import pgp.certificate_store.Certificate;
import pgp.certificate_store.CertificateReaderBackend;
import pgp.certificate_store.MergeCallback;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;
import pgp.certificate_store.exception.NotAStoreException;

public class SharedPGPCertificateDirectoryTest {
    private static MergeCallback dummyMerge = new MergeCallback(){

        public Certificate merge(Certificate data, Certificate existing) {
            return data;
        }
    };

    private static Stream<SharedPGPCertificateDirectory> provideTestSubjects() throws IOException, NotAStoreException {
        return Stream.of(new SharedPGPCertificateDirectoryImpl(SharedPGPCertificateDirectoryTest.tempDir(), (CertificateReaderBackend)new CertificateReader()), new CachingSharedPGPCertificateDirectoryWrapper((SharedPGPCertificateDirectory)new SharedPGPCertificateDirectoryImpl(SharedPGPCertificateDirectoryTest.tempDir(), (CertificateReaderBackend)new CertificateReader())));
    }

    private static File tempDir() throws IOException {
        File tempDir = Files.createTempDirectory("pgp.cert.d-", new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        return tempDir;
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestSubjects"})
    public void simpleInsertGet(SharedPGPCertificateDirectory directory) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadDataException, InterruptedException, BadNameException {
        PGPSecretKeyRing key = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)key);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)cert);
        ByteArrayInputStream certIn = new ByteArrayInputStream(cert.getEncoded());
        Assertions.assertNull((Object)directory.getByFingerprint(fingerprint.toString().toLowerCase()));
        Certificate certificate = directory.insert((InputStream)certIn, dummyMerge);
        Assertions.assertEquals((Object)fingerprint.toString().toLowerCase(), (Object)certificate.getFingerprint());
        Assertions.assertNull((Object)directory.getByFingerprintIfChanged(certificate.getFingerprint(), certificate.getTag()));
        Assertions.assertNotNull((Object)directory.getByFingerprintIfChanged(certificate.getFingerprint(), "invalidTag"));
        certIn = new ByteArrayInputStream(cert.getEncoded());
        Assertions.assertNotNull((Object)directory.tryInsert((InputStream)certIn, dummyMerge));
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestSubjects"})
    public void simpleInsertGetBySpecialName(SharedPGPCertificateDirectory directory) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadDataException, InterruptedException, BadNameException {
        PGPSecretKeyRing key = ((KeyRingBuilder)PGPainless.buildKeyRing().addUserId("trust-root").setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).build();
        PGPPublicKeyRing trustRoot = PGPainless.extractCertificate((PGPSecretKeyRing)key);
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)trustRoot);
        ByteArrayInputStream certIn = new ByteArrayInputStream(trustRoot.getEncoded());
        Assertions.assertNull((Object)directory.getBySpecialName("trust-root"));
        Certificate certificate = directory.insertWithSpecialName("trust-root", (InputStream)certIn, dummyMerge);
        Assertions.assertEquals((Object)fingerprint.toString().toLowerCase(), (Object)certificate.getFingerprint());
        Assertions.assertNull((Object)directory.getBySpecialNameIfChanged("trust-root", certificate.getTag()));
        Assertions.assertNotNull((Object)directory.getBySpecialNameIfChanged("trust-root", "invalidTag"));
        certIn = new ByteArrayInputStream(trustRoot.getEncoded());
        Assertions.assertNotNull((Object)directory.tryInsertWithSpecialName("trust-root", (InputStream)certIn, dummyMerge));
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestSubjects"})
    public void tryInsertFailsWithLockedStore(SharedPGPCertificateDirectory directory) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadDataException, InterruptedException {
        Assumptions.assumeTrue((boolean)(directory.getLock() instanceof FileLockingMechanism));
        PGPSecretKeyRing key = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)key);
        ByteArrayInputStream certIn = new ByteArrayInputStream(cert.getEncoded());
        directory.getLock().lockDirectory();
        Assertions.assertNull((Object)directory.tryInsert((InputStream)certIn, dummyMerge));
        directory.getLock().releaseDirectory();
        Assertions.assertNotNull((Object)directory.tryInsert((InputStream)certIn, dummyMerge));
    }

    @ParameterizedTest
    @MethodSource(value={"provideTestSubjects"})
    public void testGetItemsAndFingerprints(SharedPGPCertificateDirectory directory) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadDataException, InterruptedException, BadNameException {
        Object fingerprint;
        PGPSecretKeyRing trustRootKey = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        PGPPublicKeyRing trustRootCert = PGPainless.extractCertificate((PGPSecretKeyRing)trustRootKey);
        OpenPgpFingerprint trustRootFingerprint = OpenPgpFingerprint.of((PGPKeyRing)trustRootCert);
        ByteArrayInputStream trustRootCertIn = new ByteArrayInputStream(trustRootCert.getEncoded());
        directory.insertWithSpecialName("trust-root", (InputStream)trustRootCertIn, dummyMerge);
        int certificateCount = 3;
        HashMap<String, PGPPublicKeyRing> certificateMap = new HashMap<String, PGPPublicKeyRing>();
        for (int i = 0; i < 3; ++i) {
            PGPSecretKeyRing key = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
            PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)key);
            fingerprint = OpenPgpFingerprint.of((PGPKeyRing)cert);
            certificateMap.put(fingerprint.toString().toLowerCase(), cert);
            ByteArrayInputStream certIn = new ByteArrayInputStream(cert.getEncoded());
            directory.insert((InputStream)certIn, dummyMerge);
        }
        Iterator certificates = directory.items();
        int count = 0;
        while (certificates.hasNext()) {
            ++count;
            Certificate certificate = (Certificate)certificates.next();
            fingerprint = certificate.getFingerprint();
            Assertions.assertNotNull(certificateMap.get(fingerprint));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)certificate.getInputStream(), (OutputStream)out);
            Assertions.assertArrayEquals((byte[])((PGPPublicKeyRing)certificateMap.get(fingerprint)).getEncoded(), (byte[])out.toByteArray());
        }
        Assertions.assertEquals((int)3, (int)count);
        Iterator fingerprints = directory.fingerprints();
        HashSet<String> fingerprintSet = new HashSet<String>();
        while (fingerprints.hasNext()) {
            String fingerprint2 = (String)fingerprints.next();
            fingerprintSet.add(fingerprint2);
            Assertions.assertNotNull(certificateMap.get(fingerprint2));
        }
        Assertions.assertEquals((int)3, (int)fingerprintSet.size());
    }
}

