/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.certificate_store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pgp.cert_d.SharedPGPCertificateDirectory;
import pgp.cert_d.SpecialNames;
import pgp.certificate_store.Certificate;
import pgp.certificate_store.CertificateStore;
import pgp.certificate_store.MergeCallback;
import pgp.certificate_store.SubkeyLookup;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;

public class SharedPGPCertificateDirectoryAdapter
implements CertificateStore {
    private final SharedPGPCertificateDirectory directory;
    private final SubkeyLookup subkeyLookup;

    public SharedPGPCertificateDirectoryAdapter(SharedPGPCertificateDirectory directory, SubkeyLookup subkeyLookup) {
        this.directory = directory;
        this.subkeyLookup = subkeyLookup;
    }

    public Certificate getCertificate(String identifier) throws IOException, BadDataException, BadNameException {
        String specialName = SpecialNames.lookupSpecialName((String)identifier);
        if (specialName != null) {
            return this.directory.getBySpecialName(specialName);
        }
        return this.directory.getByFingerprint(identifier);
    }

    public Certificate getCertificateIfChanged(String identifier, String tag) throws IOException, BadDataException, BadNameException {
        String specialName = SpecialNames.lookupSpecialName((String)identifier);
        if (specialName != null) {
            return this.directory.getBySpecialNameIfChanged(specialName, tag);
        }
        return this.directory.getByFingerprintIfChanged(identifier, tag);
    }

    public Certificate insertCertificate(InputStream data, MergeCallback merge) throws IOException, InterruptedException, BadDataException {
        Certificate certificate = this.directory.insert(data, merge);
        this.storeIdentifierForSubkeys(certificate);
        return certificate;
    }

    public Certificate tryInsertCertificate(InputStream data, MergeCallback merge) throws IOException, BadDataException {
        Certificate certificate = this.directory.tryInsert(data, merge);
        this.storeIdentifierForSubkeys(certificate);
        return certificate;
    }

    public Certificate insertCertificateBySpecialName(String specialName, InputStream data, MergeCallback merge) throws IOException, InterruptedException, BadDataException, BadNameException {
        return this.directory.insertWithSpecialName(specialName, data, merge);
    }

    public Certificate tryInsertCertificateBySpecialName(String specialName, InputStream data, MergeCallback merge) throws IOException, BadDataException, BadNameException {
        return this.directory.tryInsertWithSpecialName(specialName, data, merge);
    }

    public Iterator<Certificate> getCertificates() {
        return this.directory.items();
    }

    public Iterator<String> getFingerprints() {
        return this.directory.fingerprints();
    }

    private void storeIdentifierForSubkeys(Certificate certificate) throws IOException {
        if (certificate == null) {
            return;
        }
        String fingerprint = certificate.getFingerprint();
        this.storeCertificateSubkeyIds(fingerprint, new ArrayList<Long>(certificate.getSubkeyIds()));
    }

    public Set<String> getCertificateFingerprintsForSubkeyId(long subkeyId) throws IOException {
        return this.subkeyLookup.getCertificateFingerprintsForSubkeyId(subkeyId);
    }

    public void storeCertificateSubkeyIds(String certificate, List<Long> subkeyIds) throws IOException {
        this.subkeyLookup.storeCertificateSubkeyIds(certificate, subkeyIds);
    }
}

