/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.certificate_store;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.util.encoders.Base64;
import org.pgpainless.key.OpenPgpFingerprint;
import pgp.certificate_store.Certificate;

public class CertificateFactory {
    public static Certificate certificateFromPublicKeyRing(final PGPPublicKeyRing publicKeyRing) {
        return new Certificate(){

            public String getFingerprint() {
                return OpenPgpFingerprint.of((PGPKeyRing)publicKeyRing).toString().toLowerCase();
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(publicKeyRing.getEncoded());
            }

            public String getTag() throws IOException {
                MessageDigest digest;
                try {
                    digest = MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AssertionError((Object)("No MessageDigest for SHA-256 instantiated, although BC is on the classpath: " + e.getMessage()));
                }
                digest.update(publicKeyRing.getEncoded());
                return Base64.toBase64String((byte[])digest.digest());
            }

            public Set<Long> getSubkeyIds() throws IOException {
                HashSet<Long> keyIds = new HashSet<Long>();
                Iterator keys = publicKeyRing.getPublicKeys();
                while (keys.hasNext()) {
                    keyIds.add(((PGPPublicKey)keys.next()).getKeyID());
                }
                return keyIds;
            }
        };
    }
}

