/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.CertificateValidator;
import org.pgpainless.signature.DetachedSignature;
import org.pgpainless.signature.OnePassSignatureCheck;
import org.pgpainless.signature.SignatureValidator;
import org.pgpainless.signature.cleartext_signatures.SignatureVerification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureInputStream
extends FilterInputStream {
    protected SignatureInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public static class CleartextSignatures
    extends SignatureInputStream {
        public CleartextSignatures(InputStream inputStream, List<PGPSignature> signatures) {
            super(inputStream);
        }
    }

    public static class VerifySignatures
    extends SignatureInputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(VerifySignatures.class);
        private final List<OnePassSignatureCheck> opSignatures;
        private final List<DetachedSignature> detachedSignatures;
        private final ConsumerOptions options;
        private final OpenPgpMetadata.Builder resultBuilder;

        public VerifySignatures(InputStream literalDataStream, List<OnePassSignatureCheck> opSignatures, List<DetachedSignature> detachedSignatures, ConsumerOptions options, OpenPgpMetadata.Builder resultBuilder) {
            super(literalDataStream);
            this.opSignatures = opSignatures;
            this.detachedSignatures = detachedSignatures;
            this.options = options;
            this.resultBuilder = resultBuilder;
        }

        @Override
        public int read() throws IOException {
            boolean endOfStream;
            int data = super.read();
            boolean bl = endOfStream = data == -1;
            if (endOfStream) {
                this.verifyOnePassSignatures();
                this.verifyDetachedSignatures();
            } else {
                byte b = (byte)data;
                this.updateOnePassSignatures(b);
                this.updateDetachedSignatures(b);
            }
            return data;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            boolean endOfStream;
            int read = super.read(b, off, len);
            boolean bl = endOfStream = read == -1;
            if (endOfStream) {
                this.verifyOnePassSignatures();
                this.verifyDetachedSignatures();
            } else {
                this.updateOnePassSignatures(b, off, read);
                this.updateDetachedSignatures(b, off, read);
            }
            return read;
        }

        private synchronized void verifyOnePassSignatures() {
            Policy policy = PGPainless.getPolicy();
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                if (opSignature.getSignature() == null) {
                    LOGGER.warn("Found OnePassSignature without respective signature packet -> skip");
                    continue;
                }
                try {
                    SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(opSignature.getSignature());
                    CertificateValidator.validateCertificateAndVerifyOnePassSignature(opSignature, policy);
                    this.resultBuilder.addVerifiedInbandSignature(new SignatureVerification(opSignature.getSignature(), opSignature.getSigningKey()));
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("One-pass-signature verification failed for signature made by key {}: {}", opSignature.getSigningKey(), e.getMessage(), e);
                    this.resultBuilder.addInvalidInbandSignature(new SignatureVerification(opSignature.getSignature(), opSignature.getSigningKey()), e);
                }
            }
        }

        private void verifyDetachedSignatures() {
            Policy policy = PGPainless.getPolicy();
            for (DetachedSignature s2 : this.detachedSignatures) {
                try {
                    SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(s2.getSignature());
                    CertificateValidator.validateCertificateAndVerifyInitializedSignature(s2.getSignature(), (PGPPublicKeyRing)s2.getSigningKeyRing(), policy);
                    this.resultBuilder.addVerifiedDetachedSignature(new SignatureVerification(s2.getSignature(), s2.getSigningKeyIdentifier()));
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("One-pass-signature verification failed for signature made by key {}: {}", s2.getSigningKeyIdentifier(), e.getMessage(), e);
                    this.resultBuilder.addInvalidDetachedSignature(new SignatureVerification(s2.getSignature(), s2.getSigningKeyIdentifier()), e);
                }
            }
        }

        private void updateOnePassSignatures(byte data) {
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                opSignature.getOnePassSignature().update(data);
            }
        }

        private void updateOnePassSignatures(byte[] bytes, int offset, int length) {
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                opSignature.getOnePassSignature().update(bytes, offset, length);
            }
        }

        private void updateDetachedSignatures(byte b) {
            for (DetachedSignature detachedSignature : this.detachedSignatures) {
                detachedSignature.getSignature().update(b);
            }
        }

        private void updateDetachedSignatures(byte[] b, int off, int read) {
            for (DetachedSignature detachedSignature : this.detachedSignatures) {
                detachedSignature.getSignature().update(b, off, read);
            }
        }
    }
}

