/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification.secretkeyring;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketGeneratorUtil;
import org.pgpainless.util.CollectionUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.userid.SelectUserId;

public class SecretKeyRingEditor
implements SecretKeyRingEditorInterface {
    private static final HashAlgorithm defaultDigestHashAlgorithm = HashAlgorithm.SHA1;
    private PGPSecretKeyRing secretKeyRing;

    public SecretKeyRingEditor(PGPSecretKeyRing secretKeyRing) {
        if (secretKeyRing == null) {
            throw new NullPointerException("SecretKeyRing MUST NOT be null.");
        }
        this.secretKeyRing = secretKeyRing;
    }

    @Override
    public SecretKeyRingEditorInterface addUserId(String userId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        userId = this.sanitizeUserId(userId);
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        Iterator<PGPSecretKey> secretKeyIterator = this.secretKeyRing.getSecretKeys();
        PGPSecretKey primaryKey = secretKeyIterator.next();
        PGPPublicKey publicKey = primaryKey.getPublicKey();
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(primaryKey, secretKeyRingProtector);
        publicKey = SecretKeyRingEditor.addUserIdToPubKey(userId, privateKey, publicKey);
        primaryKey = PGPSecretKey.replacePublicKey(primaryKey, publicKey);
        secretKeyList.add(primaryKey);
        while (secretKeyIterator.hasNext()) {
            secretKeyList.add(secretKeyIterator.next());
        }
        this.secretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return this;
    }

    private static PGPPublicKey addUserIdToPubKey(String userId, PGPPrivateKey privateKey, PGPPublicKey publicKey) throws PGPException {
        if (privateKey.getKeyID() != publicKey.getKeyID()) {
            throw new IllegalArgumentException("Key-ID mismatch!");
        }
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(publicKey);
        signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
        PGPSignature userIdSignature = signatureGenerator.generateCertification(userId, publicKey);
        publicKey = PGPPublicKey.addCertification(publicKey, userId, userIdSignature);
        return publicKey;
    }

    private String sanitizeUserId(String userId) {
        userId = userId.trim();
        return userId;
    }

    @Override
    public SecretKeyRingEditorInterface deleteUserId(String userId, SecretKeyRingProtector protector) {
        return this.deleteUserIds(SelectUserId.exactMatch(userId), protector);
    }

    @Override
    public SecretKeyRingEditorInterface deleteUserIds(SelectUserId selectionStrategy, SecretKeyRingProtector secretKeyRingProtector) {
        ArrayList<PGPPublicKey> publicKeys = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> publicKeyIterator = this.secretKeyRing.getPublicKeys();
        PGPPublicKey primaryKey = publicKeyIterator.next();
        List<String> matchingUserIds = selectionStrategy.selectUserIds(CollectionUtils.iteratorToList(primaryKey.getUserIDs()));
        if (matchingUserIds.isEmpty()) {
            throw new NoSuchElementException("Key does not have a matching user-id attribute.");
        }
        for (String userId : matchingUserIds) {
            primaryKey = PGPPublicKey.removeCertification(primaryKey, userId);
        }
        publicKeys.add(primaryKey);
        while (publicKeyIterator.hasNext()) {
            publicKeys.add(publicKeyIterator.next());
        }
        PGPPublicKeyRing publicKeyRing = new PGPPublicKeyRing(publicKeys);
        this.secretKeyRing = PGPSecretKeyRing.replacePublicKeys(this.secretKeyRing, publicKeyRing);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(@Nonnull KeySpec keySpec, @Nonnull Passphrase subKeyPassphrase, SecretKeyRingProtector secretKeyRingProtector) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKey secretSubKey = this.generateSubKey(keySpec, subKeyPassphrase);
        PasswordBasedSecretKeyRingProtector subKeyProtector = PasswordBasedSecretKeyRingProtector.forKey(secretSubKey, subKeyPassphrase);
        PGPSignatureSubpacketVector hashedSubpackets = keySpec.getSubpackets();
        PGPSignatureSubpacketVector unhashedSubpackets = null;
        return this.addSubKey(secretSubKey, hashedSubpackets, unhashedSubpackets, subKeyProtector, secretKeyRingProtector);
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(PGPSecretKey secretSubKey, PGPSignatureSubpacketVector hashedSubpackets, PGPSignatureSubpacketVector unhashedSubpackets, SecretKeyRingProtector subKeyProtector, SecretKeyRingProtector keyRingProtector) throws PGPException {
        PGPPublicKey primaryKey = this.secretKeyRing.getSecretKey().getPublicKey();
        PBESecretKeyDecryptor ringDecryptor = keyRingProtector.getDecryptor(primaryKey.getKeyID());
        PBESecretKeyEncryptor subKeyEncryptor = subKeyProtector.getEncryptor(secretSubKey.getKeyID());
        PGPDigestCalculator digestCalculator = ImplementationFactory.getInstance().getPGPDigestCalculator(defaultDigestHashAlgorithm);
        PGPContentSignerBuilder contentSignerBuilder = ImplementationFactory.getInstance().getPGPContentSignerBuilder(primaryKey.getAlgorithm(), HashAlgorithm.SHA256.getAlgorithmId());
        PGPPrivateKey privateSubKey = UnlockSecretKey.unlockSecretKey(secretSubKey, subKeyProtector);
        PGPKeyPair subKeyPair = new PGPKeyPair(secretSubKey.getPublicKey(), privateSubKey);
        PGPKeyRingGenerator keyRingGenerator = new PGPKeyRingGenerator(this.secretKeyRing, ringDecryptor, digestCalculator, contentSignerBuilder, subKeyEncryptor);
        keyRingGenerator.addSubKey(subKeyPair, hashedSubpackets, unhashedSubpackets);
        this.secretKeyRing = keyRingGenerator.generateSecretKeyRing();
        return this;
    }

    private PGPSecretKey generateSubKey(@Nonnull KeySpec keySpec, @Nonnull Passphrase subKeyPassphrase) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPDigestCalculator checksumCalculator = ImplementationFactory.getInstance().getPGPDigestCalculator(defaultDigestHashAlgorithm);
        PBESecretKeyEncryptor subKeyEncryptor = subKeyPassphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyEncryptor(SymmetricKeyAlgorithm.AES_256, subKeyPassphrase);
        PGPKeyPair keyPair = KeyRingBuilder.generateKeyPair(keySpec);
        PGPSecretKey secretKey = new PGPSecretKey(keyPair.getPrivateKey(), keyPair.getPublicKey(), checksumCalculator, false, subKeyEncryptor);
        return secretKey;
    }

    @Override
    public SecretKeyRingEditorInterface deleteSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector protector) {
        return this.deleteSubKey(fingerprint.getKeyId(), protector);
    }

    @Override
    public SecretKeyRingEditorInterface deleteSubKey(long subKeyId, SecretKeyRingProtector protector) {
        PGPSecretKeyRing newKeyRing;
        if (this.secretKeyRing.getSecretKey().getKeyID() == subKeyId) {
            throw new IllegalArgumentException("You cannot delete the primary key of this key ring.");
        }
        PGPSecretKey deleteMe = this.secretKeyRing.getSecretKey(subKeyId);
        if (deleteMe == null) {
            throw new NoSuchElementException("KeyRing does not contain a key with keyId " + Long.toHexString(subKeyId));
        }
        this.secretKeyRing = newKeyRing = PGPSecretKeyRing.removeSecretKey(this.secretKeyRing, deleteMe);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface revoke(SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        return this.revokeSubKey(this.secretKeyRing.getSecretKey().getKeyID(), secretKeyRingProtector, revocationAttributes);
    }

    @Override
    public SecretKeyRingEditorInterface revokeSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector protector, RevocationAttributes revocationAttributes) throws PGPException {
        return this.revokeSubKey(fingerprint.getKeyId(), protector, revocationAttributes);
    }

    @Override
    public SecretKeyRingEditorInterface revokeSubKey(long subKeyId, SecretKeyRingProtector protector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = this.secretKeyRing.getPublicKey(subKeyId);
        if (revokeeSubKey == null) {
            throw new NoSuchElementException("No subkey with id " + Long.toHexString(subKeyId) + " found.");
        }
        this.secretKeyRing = this.revokeSubKey(protector, revokeeSubKey, revocationAttributes);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface revokeUserId(String userId, SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        Iterator<String> userIds = this.secretKeyRing.getPublicKey().getUserIDs();
        boolean found = false;
        while (userIds.hasNext()) {
            if (!userId.equals(userIds.next())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new NoSuchElementException("No user-id '" + userId + "' found on the key.");
        }
        return this.doRevokeUserId(userId, secretKeyRingProtector, revocationAttributes);
    }

    private SecretKeyRingEditorInterface doRevokeUserId(String userId, SecretKeyRingProtector protector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPSecretKey primarySecretKey = this.secretKeyRing.getSecretKey();
        PGPPublicKey primaryPublicKey = primarySecretKey.getPublicKey();
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(primarySecretKey, protector);
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setSignatureCreationTime(false, new Date());
        subpacketGenerator.setRevocable(false, false);
        subpacketGenerator.setIssuerFingerprint(false, primarySecretKey);
        if (revocationAttributes != null) {
            RevocationAttributes.Reason reason = revocationAttributes.getReason();
            if (reason != RevocationAttributes.Reason.NO_REASON && reason != RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID) {
                throw new IllegalArgumentException("Revocation reason must either be NO_REASON or USER_ID_NO_LONGER_VALID");
            }
            subpacketGenerator.setRevocationReason(false, revocationAttributes.getReason().code(), revocationAttributes.getDescription());
        }
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(primarySecretKey);
        signatureGenerator.setHashedSubpackets(subpacketGenerator.generate());
        signatureGenerator.init(SignatureType.CERTIFICATION_REVOCATION.getCode(), privateKey);
        PGPSignature revocationSignature = signatureGenerator.generateCertification(userId, primaryPublicKey);
        primaryPublicKey = PGPPublicKey.addCertification(primaryPublicKey, userId, revocationSignature);
        PGPPublicKeyRing publicKeyRing = KeyRingUtils.publicKeyRingFrom(this.secretKeyRing);
        publicKeyRing = PGPPublicKeyRing.insertPublicKey(publicKeyRing, primaryPublicKey);
        this.secretKeyRing = PGPSecretKeyRing.replacePublicKeys(this.secretKeyRing, publicKeyRing);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface setExpirationDate(Date expiration, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.setExpirationDate(new OpenPgpV4Fingerprint(this.secretKeyRing), expiration, secretKeyRingProtector);
    }

    @Override
    public SecretKeyRingEditorInterface setExpirationDate(OpenPgpV4Fingerprint fingerprint, Date expiration, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        if (!primaryKey.isMasterKey()) {
            throw new IllegalArgumentException("Key Ring does not appear to contain a primary secret key.");
        }
        boolean found = false;
        for (PGPSecretKey secretKey : this.secretKeyRing) {
            if (secretKey.getKeyID() != fingerprint.getKeyId()) {
                secretKeyList.add(secretKey);
                continue;
            }
            found = true;
            secretKey = this.setExpirationDate(primaryKey, secretKey, expiration, secretKeyRingProtector);
            secretKeyList.add(secretKey);
        }
        if (!found) {
            throw new IllegalArgumentException("Key Ring does not contain secret key with fingerprint " + fingerprint);
        }
        this.secretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return this;
    }

    private PGPSecretKey setExpirationDate(PGPSecretKey primaryKey, PGPSecretKey subjectKey, Date expiration, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        if (expiration != null && expiration.before(subjectKey.getPublicKey().getCreationTime())) {
            throw new IllegalArgumentException("Expiration date cannot be before creation date.");
        }
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(primaryKey, secretKeyRingProtector);
        PGPPublicKey subjectPubKey = subjectKey.getPublicKey();
        PGPSignature oldSignature = this.getPreviousSignature(primaryKey, subjectPubKey);
        PGPSignatureSubpacketVector oldSubpackets = oldSignature.getHashedSubPackets();
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator(oldSubpackets);
        SignatureSubpacketGeneratorUtil.setSignatureCreationTimeInSubpacketGenerator(new Date(), subpacketGenerator);
        SignatureSubpacketGeneratorUtil.setExpirationDateInSubpacketGenerator(expiration, subjectPubKey.getCreationTime(), subpacketGenerator);
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(primaryKey);
        signatureGenerator.setHashedSubpackets(subpacketGenerator.generate());
        if (primaryKey.getKeyID() == subjectKey.getKeyID()) {
            signatureGenerator.init(19, privateKey);
            Iterator<String> it = subjectKey.getUserIDs();
            while (it.hasNext()) {
                String userId = it.next();
                PGPSignature signature = signatureGenerator.generateCertification(userId, subjectPubKey);
                subjectPubKey = PGPPublicKey.addCertification(subjectPubKey, userId, signature);
            }
        } else {
            signatureGenerator.init(24, privateKey);
            PGPSignature signature = signatureGenerator.generateCertification(primaryKey.getPublicKey(), subjectPubKey);
            subjectPubKey = PGPPublicKey.addCertification(subjectPubKey, signature);
        }
        subjectKey = PGPSecretKey.replacePublicKey(subjectKey, subjectPubKey);
        return subjectKey;
    }

    private PGPSignature getPreviousSignature(PGPSecretKey primaryKey, PGPPublicKey subjectPubKey) {
        PGPSignature oldSignature = null;
        if (primaryKey.getKeyID() == subjectPubKey.getKeyID()) {
            Iterator<PGPSignature> keySignatures = subjectPubKey.getSignaturesForKeyID(primaryKey.getKeyID());
            while (keySignatures.hasNext()) {
                PGPSignature next = keySignatures.next();
                if (next.getSignatureType() != 19) continue;
                oldSignature = next;
            }
            if (oldSignature == null) {
                throw new IllegalStateException("Key " + new OpenPgpV4Fingerprint(subjectPubKey) + " does not have a previous positive signature.");
            }
        } else {
            Iterator<PGPSignature> bindingSignatures = subjectPubKey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
            while (bindingSignatures.hasNext()) {
                oldSignature = bindingSignatures.next();
            }
        }
        if (oldSignature == null) {
            throw new IllegalStateException("Key " + new OpenPgpV4Fingerprint(subjectPubKey) + " does not have a previous subkey binding signature.");
        }
        return oldSignature;
    }

    @Override
    public PGPSignature createRevocationCertificate(SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = this.secretKeyRing.getPublicKey();
        PGPSignature revocationCertificate = this.generateRevocation(secretKeyRingProtector, revokeeSubKey, revocationAttributes);
        return revocationCertificate;
    }

    @Override
    public PGPSignature createRevocationCertificate(long subkeyId, SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = KeyRingUtils.requirePublicKeyFrom(this.secretKeyRing, subkeyId);
        PGPSignature revocationCertificate = this.generateRevocation(secretKeyRingProtector, revokeeSubKey, revocationAttributes);
        return revocationCertificate;
    }

    private PGPSecretKeyRing revokeSubKey(SecretKeyRingProtector protector, PGPPublicKey revokeeSubKey, RevocationAttributes revocationAttributes) throws PGPException {
        PGPSignature subKeyRevocation = this.generateRevocation(protector, revokeeSubKey, revocationAttributes);
        revokeeSubKey = PGPPublicKey.addCertification(revokeeSubKey, subKeyRevocation);
        PGPPublicKeyRing publicKeyRing = KeyRingUtils.publicKeyRingFrom(this.secretKeyRing);
        publicKeyRing = PGPPublicKeyRing.insertPublicKey(publicKeyRing, revokeeSubKey);
        return PGPSecretKeyRing.replacePublicKeys(this.secretKeyRing, publicKeyRing);
    }

    private PGPSignature generateRevocation(SecretKeyRingProtector protector, PGPPublicKey revokeeSubKey, RevocationAttributes revocationAttributes) throws PGPException {
        PGPSignature revocation;
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(primaryKey);
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setIssuerFingerprint(false, primaryKey);
        if (revocationAttributes != null) {
            subpacketGenerator.setRevocationReason(false, revocationAttributes.getReason().code(), revocationAttributes.getDescription());
        }
        PGPSignatureSubpacketVector subPackets = subpacketGenerator.generate();
        signatureGenerator.setHashedSubpackets(subPackets);
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(primaryKey, protector);
        if (revokeeSubKey.isMasterKey()) {
            signatureGenerator.init(SignatureType.KEY_REVOCATION.getCode(), privateKey);
            revocation = signatureGenerator.generateCertification(revokeeSubKey);
        } else {
            signatureGenerator.init(SignatureType.SUBKEY_REVOCATION.getCode(), privateKey);
            revocation = signatureGenerator.generateCertification(primaryKey.getPublicKey(), revokeeSubKey);
        }
        return revocation;
    }

    @Override
    public SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(oldProtectionSettings, new SolitaryPassphraseProvider(oldPassphrase));
        return new WithKeyRingEncryptionSettingsImpl(null, protector);
    }

    @Override
    public SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        Map<Long, Passphrase> passphraseMap = Collections.singletonMap(keyId, oldPassphrase);
        CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector(passphraseMap, oldProtectionSettings, null);
        return new WithKeyRingEncryptionSettingsImpl(keyId, protector);
    }

    @Override
    public PGPSecretKeyRing done() {
        return this.secretKeyRing;
    }

    private PGPSecretKeyRing changePassphrase(Long keyId, PGPSecretKeyRing secretKeys, SecretKeyRingProtector oldProtector, SecretKeyRingProtector newProtector) throws PGPException {
        if (keyId == null) {
            ArrayList<PGPSecretKey> newlyEncryptedSecretKeys = new ArrayList<PGPSecretKey>();
            Iterator<PGPSecretKey> secretKeyIterator = secretKeys.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = secretKeyIterator.next();
                secretKey = SecretKeyRingEditor.reencryptPrivateKey(secretKey, oldProtector, newProtector);
                newlyEncryptedSecretKeys.add(secretKey);
            }
            return new PGPSecretKeyRing(newlyEncryptedSecretKeys);
        }
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        Iterator<PGPSecretKey> secretKeyIterator = secretKeys.getSecretKeys();
        while (secretKeyIterator.hasNext()) {
            PGPSecretKey secretKey = secretKeyIterator.next();
            if (secretKey.getPublicKey().getKeyID() == keyId.longValue()) {
                secretKey = SecretKeyRingEditor.reencryptPrivateKey(secretKey, oldProtector, newProtector);
            }
            secretKeyList.add(secretKey);
        }
        return new PGPSecretKeyRing(secretKeyList);
    }

    private static PGPSecretKey reencryptPrivateKey(PGPSecretKey secretKey, SecretKeyRingProtector oldProtector, SecretKeyRingProtector newProtector) throws PGPException {
        S2K s2k = secretKey.getS2K();
        if (s2k == null || s2k.getType() != 101) {
            long secretKeyId = secretKey.getKeyID();
            PBESecretKeyDecryptor decryptor = oldProtector.getDecryptor(secretKeyId);
            PBESecretKeyEncryptor encryptor = newProtector.getEncryptor(secretKeyId);
            secretKey = PGPSecretKey.copyWithNewPassword(secretKey, decryptor, encryptor);
        }
        return secretKey;
    }

    private final class WithPassphraseImpl
    implements SecretKeyRingEditorInterface.WithPassphrase {
        private final SecretKeyRingProtector oldProtector;
        private final KeyRingProtectionSettings newProtectionSettings;
        private final Long keyId;

        private WithPassphraseImpl(Long keyId, SecretKeyRingProtector oldProtector, KeyRingProtectionSettings newProtectionSettings) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
            this.newProtectionSettings = newProtectionSettings;
        }

        @Override
        public SecretKeyRingEditorInterface toNewPassphrase(Passphrase passphrase) throws PGPException {
            PasswordBasedSecretKeyRingProtector newProtector = new PasswordBasedSecretKeyRingProtector(this.newProtectionSettings, new SolitaryPassphraseProvider(passphrase));
            PGPSecretKeyRing secretKeys = SecretKeyRingEditor.this.changePassphrase(this.keyId, SecretKeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            SecretKeyRingEditor.this.secretKeyRing = secretKeys;
            return SecretKeyRingEditor.this;
        }

        @Override
        public SecretKeyRingEditorInterface toNoPassphrase() throws PGPException {
            UnprotectedKeysProtector newProtector = new UnprotectedKeysProtector();
            PGPSecretKeyRing secretKeys = SecretKeyRingEditor.this.changePassphrase(this.keyId, SecretKeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            SecretKeyRingEditor.this.secretKeyRing = secretKeys;
            return SecretKeyRingEditor.this;
        }
    }

    private final class WithKeyRingEncryptionSettingsImpl
    implements SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings {
        private final Long keyId;
        private final SecretKeyRingProtector oldProtector;

        private WithKeyRingEncryptionSettingsImpl(Long keyId, SecretKeyRingProtector oldProtector) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
        }

        @Override
        public SecretKeyRingEditorInterface.WithPassphrase withSecureDefaultSettings() {
            return this.withCustomSettings(KeyRingProtectionSettings.secureDefaultSettings());
        }

        @Override
        public SecretKeyRingEditorInterface.WithPassphrase withCustomSettings(KeyRingProtectionSettings settings) {
            return new WithPassphraseImpl(this.keyId, this.oldProtector, settings);
        }
    }
}

