/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.key.SubkeyIdentifier;

public class OnePassSignatureCheck {
    private final PGPOnePassSignature onePassSignature;
    private final PGPPublicKeyRing verificationKeys;
    private PGPSignature signature;
    private boolean verified;

    public OnePassSignatureCheck(PGPOnePassSignature onePassSignature, PGPPublicKeyRing verificationKeys) {
        this.onePassSignature = onePassSignature;
        this.verificationKeys = verificationKeys;
    }

    public void setSignature(PGPSignature signature) {
        this.signature = signature;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public PGPOnePassSignature getOnePassSignature() {
        return this.onePassSignature;
    }

    public SubkeyIdentifier getSigningKey() {
        return new SubkeyIdentifier((PGPKeyRing)this.verificationKeys, this.onePassSignature.getKeyID());
    }

    public boolean verify() throws PGPException {
        if (this.signature == null) {
            throw new IllegalStateException("No comparison signature provided.");
        }
        this.verified = this.getOnePassSignature().verify(this.signature);
        return this.verified;
    }

    public PGPSignature getSignature() {
        return this.signature;
    }

    public PGPPublicKeyRing getVerificationKeys() {
        return this.verificationKeys;
    }
}

