/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.cleartext_signatures;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.signature.CertificateValidator;
import org.pgpainless.signature.SignatureValidator;
import org.pgpainless.signature.SignatureVerifier;
import org.pgpainless.signature.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.signature.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.signature.cleartext_signatures.SignatureVerification;
import org.pgpainless.util.ArmoredInputStreamFactory;

public class CleartextSignatureProcessor {
    private static final Logger LOGGER = Logger.getLogger(CleartextSignatureProcessor.class.getName());
    private final ArmoredInputStream in;
    private final ConsumerOptions options;
    private final MultiPassStrategy multiPassStrategy;

    public CleartextSignatureProcessor(InputStream inputStream, ConsumerOptions options, MultiPassStrategy multiPassStrategy) throws IOException {
        this.in = inputStream instanceof ArmoredInputStream ? (ArmoredInputStream)inputStream : ArmoredInputStreamFactory.get(inputStream);
        this.options = options;
        this.multiPassStrategy = multiPassStrategy;
    }

    public OpenPgpMetadata process() throws IOException, PGPException {
        OpenPgpMetadata.Builder resultBuilder = OpenPgpMetadata.getBuilder();
        resultBuilder.setCompressionAlgorithm(CompressionAlgorithm.UNCOMPRESSED).setSymmetricKeyAlgorithm(SymmetricKeyAlgorithm.NULL).setFileEncoding(StreamEncoding.TEXT);
        PGPSignatureList signatures = ClearsignedMessageUtil.detachSignaturesFromInbandClearsignedMessage(this.in, this.multiPassStrategy.getMessageOutputStream());
        for (PGPSignature signature : signatures) {
            PGPPublicKeyRing certificate = null;
            PGPPublicKey signingKey = null;
            for (PGPPublicKeyRing cert : this.options.getCertificates()) {
                signingKey = cert.getPublicKey(signature.getKeyID());
                if (signingKey == null) continue;
                certificate = cert;
                break;
            }
            try {
                if (signingKey == null) {
                    throw new SignatureValidationException("Missing verification key with key-id " + Long.toHexString(signature.getKeyID()));
                }
                SubkeyIdentifier signingKeyIdentifier = new SubkeyIdentifier(certificate, signingKey.getKeyID());
                SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(signature);
                SignatureVerifier.initializeSignatureAndUpdateWithSignedData(signature, this.multiPassStrategy.getMessageInputStream(), signingKey);
                CertificateValidator.validateCertificateAndVerifyInitializedSignature(signature, certificate, PGPainless.getPolicy());
                resultBuilder.addVerifiedInbandSignature(new SignatureVerification(signature, signingKeyIdentifier));
            }
            catch (SignatureValidationException e) {
                LOGGER.log(Level.INFO, "Cannot verify signature made by key " + Long.toHexString(signature.getKeyID()) + ": " + e.getMessage());
                SubkeyIdentifier signingKeyIdentifier = null;
                if (signingKey != null) {
                    signingKeyIdentifier = new SubkeyIdentifier((PGPKeyRing)certificate, signingKey.getKeyID());
                }
                resultBuilder.addInvalidInbandSignature(new SignatureVerification(signature, signingKeyIdentifier), e);
            }
        }
        return resultBuilder.build();
    }
}

