/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.ArmorUtils;

public final class MessageInspector {
    private MessageInspector() {
    }

    public static EncryptionInfo determineEncryptionInfoForMessage(InputStream dataIn) throws IOException, PGPException {
        InputStream decoded = ArmorUtils.getDecoderStream(dataIn);
        EncryptionInfo info = new EncryptionInfo();
        MessageInspector.collectDecryptionKeyIDs(decoded, info);
        return info;
    }

    private static void collectDecryptionKeyIDs(InputStream dataIn, EncryptionInfo info) throws PGPException {
        PGPObjectFactory objectFactory = new PGPObjectFactory(dataIn, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        for (Object next : objectFactory) {
            if (next instanceof PGPEncryptedDataList) {
                PGPEncryptedDataList encryptedDataList = (PGPEncryptedDataList)next;
                for (PGPEncryptedData encryptedData : encryptedDataList) {
                    if (encryptedData instanceof PGPPublicKeyEncryptedData) {
                        PGPPublicKeyEncryptedData pubKeyEncryptedData = (PGPPublicKeyEncryptedData)encryptedData;
                        info.keyIds.add(pubKeyEncryptedData.getKeyID());
                        continue;
                    }
                    if (!(encryptedData instanceof PGPPBEEncryptedData)) continue;
                    info.isPassphraseEncrypted = true;
                }
            }
            if (next instanceof PGPCompressedData) {
                PGPCompressedData compressed = (PGPCompressedData)next;
                InputStream decompressed = compressed.getDataStream();
                MessageInspector.collectDecryptionKeyIDs(decompressed, info);
            }
            if (!(next instanceof PGPLiteralData)) continue;
            return;
        }
    }

    public static class EncryptionInfo {
        private final List<Long> keyIds = new ArrayList<Long>();
        private boolean isPassphraseEncrypted = false;

        public List<Long> getKeyIds() {
            return Collections.unmodifiableList(this.keyIds);
        }

        public boolean isPassphraseEncrypted() {
            return this.isPassphraseEncrypted;
        }
    }
}

