/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.exception.NotYetImplementedException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.Passphrase;

public class ConsumerOptions {
    private boolean ignoreMDCErrors = false;
    private Date verifyNotBefore = null;
    private Date verifyNotAfter = new Date();
    private final Set<PGPPublicKeyRing> certificates = new HashSet<PGPPublicKeyRing>();
    private final Set<PGPSignature> detachedSignatures = new HashSet<PGPSignature>();
    private MissingPublicKeyCallback missingCertificateCallback = null;
    private byte[] sessionKey = null;
    private final Map<PGPSecretKeyRing, SecretKeyRingProtector> decryptionKeys = new HashMap<PGPSecretKeyRing, SecretKeyRingProtector>();
    private final Set<Passphrase> decryptionPassphrases = new HashSet<Passphrase>();

    public ConsumerOptions verifyNotBefore(Date timestamp) {
        this.verifyNotBefore = timestamp;
        return this;
    }

    @Nullable
    public Date getVerifyNotBefore() {
        return this.verifyNotBefore;
    }

    public ConsumerOptions verifyNotAfter(Date timestamp) {
        this.verifyNotAfter = timestamp;
        return this;
    }

    public Date getVerifyNotAfter() {
        return this.verifyNotAfter;
    }

    public ConsumerOptions addVerificationCert(PGPPublicKeyRing verificationCert) {
        this.certificates.add(verificationCert);
        return this;
    }

    public ConsumerOptions addVerificationCerts(PGPPublicKeyRingCollection verificationCerts) {
        for (PGPPublicKeyRing certificate : verificationCerts) {
            this.addVerificationCert(certificate);
        }
        return this;
    }

    public ConsumerOptions addVerificationOfDetachedSignatures(InputStream signatureInputStream) throws IOException, PGPException {
        List<PGPSignature> signatures = SignatureUtils.readSignatures(signatureInputStream);
        return this.addVerificationOfDetachedSignatures(signatures);
    }

    public ConsumerOptions addVerificationOfDetachedSignatures(List<PGPSignature> detachedSignatures) {
        for (PGPSignature signature : detachedSignatures) {
            this.addVerificationOfDetachedSignature(signature);
        }
        return this;
    }

    public ConsumerOptions addVerificationOfDetachedSignature(PGPSignature detachedSignature) {
        this.detachedSignatures.add(detachedSignature);
        return this;
    }

    public ConsumerOptions setMissingCertificateCallback(MissingPublicKeyCallback callback) {
        this.missingCertificateCallback = callback;
        return this;
    }

    public ConsumerOptions setSessionKey(@Nonnull byte[] sessionKey) {
        this.sessionKey = sessionKey;
        throw new NotYetImplementedException();
    }

    @Nullable
    public byte[] getSessionKey() {
        if (this.sessionKey == null) {
            return null;
        }
        byte[] sk = new byte[this.sessionKey.length];
        System.arraycopy(this.sessionKey, 0, sk, 0, this.sessionKey.length);
        return sk;
    }

    public ConsumerOptions addDecryptionKey(@Nonnull PGPSecretKeyRing key) {
        return this.addDecryptionKey(key, SecretKeyRingProtector.unprotectedKeys());
    }

    public ConsumerOptions addDecryptionKey(@Nonnull PGPSecretKeyRing key, @Nonnull SecretKeyRingProtector keyRingProtector) {
        this.decryptionKeys.put(key, keyRingProtector);
        return this;
    }

    public ConsumerOptions addDecryptionKeys(@Nonnull PGPSecretKeyRingCollection keys, @Nonnull SecretKeyRingProtector keyRingProtector) {
        for (PGPSecretKeyRing key : keys) {
            this.addDecryptionKey(key, keyRingProtector);
        }
        return this;
    }

    public ConsumerOptions addDecryptionPassphrase(@Nonnull Passphrase passphrase) {
        this.decryptionPassphrases.add(passphrase);
        return this;
    }

    @Nonnull
    public Set<PGPSecretKeyRing> getDecryptionKeys() {
        return Collections.unmodifiableSet(this.decryptionKeys.keySet());
    }

    @Nonnull
    public Set<Passphrase> getDecryptionPassphrases() {
        return Collections.unmodifiableSet(this.decryptionPassphrases);
    }

    @Nonnull
    public Set<PGPPublicKeyRing> getCertificates() {
        return Collections.unmodifiableSet(this.certificates);
    }

    @Nullable
    public MissingPublicKeyCallback getMissingCertificateCallback() {
        return this.missingCertificateCallback;
    }

    @Nonnull
    public SecretKeyRingProtector getSecretKeyProtector(PGPSecretKeyRing decryptionKeyRing) {
        return this.decryptionKeys.get(decryptionKeyRing);
    }

    @Nonnull
    public Set<PGPSignature> getDetachedSignatures() {
        return Collections.unmodifiableSet(this.detachedSignatures);
    }

    @Deprecated
    public ConsumerOptions setIgnoreMDCErrors(boolean ignoreMDCErrors) {
        this.ignoreMDCErrors = ignoreMDCErrors;
        return this;
    }

    boolean isIgnoreMDCErrors() {
        return this.ignoreMDCErrors;
    }
}

