/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.UserId;
import org.pgpainless.provider.ProviderFactory;
import org.pgpainless.signature.subpackets.SignatureSubpacketGeneratorUtil;
import org.pgpainless.util.Passphrase;

public class KeyRingBuilder
implements KeyRingBuilderInterface<KeyRingBuilder> {
    private final Charset UTF8 = Charset.forName("UTF-8");
    private PGPSignatureGenerator signatureGenerator;
    private PGPDigestCalculator digestCalculator;
    private PBESecretKeyEncryptor secretKeyEncryptor;
    private KeySpec primaryKeySpec;
    private final List<KeySpec> subkeySpecs = new ArrayList<KeySpec>();
    private final Set<String> userIds = new LinkedHashSet<String>();
    private Passphrase passphrase = null;
    private Date expirationDate = null;

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull UserId userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId.toString(), length);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId, length, null);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull UserId userId, @Nonnull RsaLength length, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId.toString(), length, password);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyRingBuilder builder = ((KeyRingBuilder)new KeyRingBuilder().setPrimaryKey(KeySpec.getBuilder(KeyType.RSA(length), KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS))).addUserId(userId);
        if (!KeyRingBuilder.isNullOrEmpty(password)) {
            builder.setPassphrase(Passphrase.fromPassword(password));
        }
        return builder.build();
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull UserId userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId.toString());
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull String userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId, null);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull UserId userId, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId.toString(), password);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull String userId, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyRingBuilder builder = ((KeyRingBuilder)((KeyRingBuilder)new KeyRingBuilder().setPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519), KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA))).addSubkey(KeySpec.getBuilder(KeyType.XDH(XDHSpec._X25519), KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS))).addUserId(userId);
        if (!KeyRingBuilder.isNullOrEmpty(password)) {
            builder.setPassphrase(Passphrase.fromPassword(password));
        }
        return builder.build();
    }

    public PGPSecretKeyRing modernKeyRing(String userId, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        KeyRingBuilder builder = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)new KeyRingBuilder().setPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519), KeyFlag.CERTIFY_OTHER, new KeyFlag[0]))).addSubkey(KeySpec.getBuilder(KeyType.XDH(XDHSpec._X25519), KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS))).addSubkey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519), KeyFlag.SIGN_DATA, new KeyFlag[0]))).addUserId(userId);
        if (!KeyRingBuilder.isNullOrEmpty(password)) {
            builder.setPassphrase(Passphrase.fromPassword(password));
        }
        return builder.build();
    }

    @Override
    public KeyRingBuilder setPrimaryKey(@Nonnull KeySpec keySpec) {
        this.verifyMasterKeyCanCertify(keySpec);
        this.primaryKeySpec = keySpec;
        return this;
    }

    @Override
    public KeyRingBuilder addSubkey(@Nonnull KeySpec keySpec) {
        this.subkeySpecs.add(keySpec);
        return this;
    }

    @Override
    public KeyRingBuilder addUserId(@Nonnull String userId) {
        this.userIds.add(userId.trim());
        return this;
    }

    @Override
    public KeyRingBuilder addUserId(@Nonnull byte[] userId) {
        return this.addUserId(new String(userId, this.UTF8));
    }

    @Override
    public KeyRingBuilder setExpirationDate(@Nonnull Date expirationDate) {
        Date now = new Date();
        if (now.after(expirationDate)) {
            throw new IllegalArgumentException("Expiration date must be in the future.");
        }
        this.expirationDate = expirationDate;
        return this;
    }

    @Override
    public KeyRingBuilder setPassphrase(@Nonnull Passphrase passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    private static boolean isNullOrEmpty(String password) {
        return password == null || password.trim().isEmpty();
    }

    private void verifyMasterKeyCanCertify(KeySpec spec) {
        if (!this.hasCertifyOthersFlag(spec)) {
            throw new IllegalArgumentException("Certification Key MUST have KeyFlag CERTIFY_OTHER");
        }
        if (!this.keyIsCertificationCapable(spec)) {
            throw new IllegalArgumentException("Key algorithm " + spec.getKeyType().getName() + " is not capable of creating certifications.");
        }
    }

    private boolean hasCertifyOthersFlag(KeySpec keySpec) {
        return SignatureSubpacketGeneratorUtil.hasKeyFlag(KeyFlag.CERTIFY_OTHER, keySpec.getSubpacketGenerator());
    }

    private boolean keyIsCertificationCapable(KeySpec keySpec) {
        return keySpec.getKeyType().canCertify();
    }

    @Override
    public PGPSecretKeyRing build() throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
        if (this.userIds.isEmpty()) {
            throw new IllegalStateException("At least one user-id is required.");
        }
        this.digestCalculator = this.buildDigestCalculator();
        this.secretKeyEncryptor = this.buildSecretKeyEncryptor();
        PBESecretKeyDecryptor secretKeyDecryptor = this.buildSecretKeyDecryptor();
        if (this.passphrase != null) {
            this.passphrase.clear();
        }
        PGPKeyPair certKey = KeyRingBuilder.generateKeyPair(this.primaryKeySpec);
        PGPContentSignerBuilder signer = this.buildContentSigner(certKey);
        this.signatureGenerator = new PGPSignatureGenerator(signer);
        PGPSignatureSubpacketGenerator hashedSubPacketGenerator = this.primaryKeySpec.getSubpacketGenerator();
        hashedSubPacketGenerator.setPrimaryUserID(false, true);
        if (this.expirationDate != null) {
            SignatureSubpacketGeneratorUtil.setExpirationDateInSubpacketGenerator(this.expirationDate, new Date(), hashedSubPacketGenerator);
        }
        PGPSignatureSubpacketVector hashedSubPackets = hashedSubPacketGenerator.generate();
        PGPKeyRingGenerator ringGenerator = this.buildRingGenerator(certKey, signer, hashedSubPackets);
        this.addSubKeys(certKey, ringGenerator);
        PGPSecretKeyRing secretKeyRing = ringGenerator.generateSecretKeyRing();
        Iterator<PGPSecretKey> secretKeys = secretKeyRing.getSecretKeys();
        PGPPublicKey primaryPubKey = secretKeys.next().getPublicKey();
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(secretKeyRing.getSecretKey(), secretKeyDecryptor);
        Iterator<String> additionalUserIds = this.userIds.iterator();
        additionalUserIds.next();
        while (additionalUserIds.hasNext()) {
            String additionalUserId = additionalUserIds.next();
            this.signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
            PGPSignature additionalUserIdSignature = this.signatureGenerator.generateCertification(additionalUserId, primaryPubKey);
            primaryPubKey = PGPPublicKey.addCertification(primaryPubKey, additionalUserId, additionalUserIdSignature);
        }
        PGPSecretKey primarySecKey = new PGPSecretKey(privateKey, primaryPubKey, this.digestCalculator, true, this.secretKeyEncryptor);
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        secretKeyList.add(primarySecKey);
        while (secretKeys.hasNext()) {
            secretKeyList.add(secretKeys.next());
        }
        secretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return secretKeyRing;
    }

    private PGPKeyRingGenerator buildRingGenerator(PGPKeyPair certKey, PGPContentSignerBuilder signer, PGPSignatureSubpacketVector hashedSubPackets) throws PGPException {
        String primaryUserId = this.userIds.iterator().next();
        return new PGPKeyRingGenerator(SignatureType.POSITIVE_CERTIFICATION.getCode(), certKey, primaryUserId, this.digestCalculator, hashedSubPackets, null, signer, this.secretKeyEncryptor);
    }

    private void addSubKeys(PGPKeyPair primaryKey, PGPKeyRingGenerator ringGenerator) throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
        for (KeySpec subKeySpec : this.subkeySpecs) {
            PGPKeyPair subKey = KeyRingBuilder.generateKeyPair(subKeySpec);
            if (subKeySpec.isInheritedSubPackets()) {
                ringGenerator.addSubKey(subKey);
                continue;
            }
            PGPSignatureSubpacketVector hashedSubpackets = subKeySpec.getSubpackets();
            try {
                hashedSubpackets = this.addPrimaryKeyBindingSignatureIfNecessary(primaryKey, subKey, hashedSubpackets);
            }
            catch (IOException e) {
                throw new PGPException("Exception while adding primary key binding signature to signing subkey", e);
            }
            ringGenerator.addSubKey(subKey, hashedSubpackets, null);
        }
    }

    private PGPSignatureSubpacketVector addPrimaryKeyBindingSignatureIfNecessary(PGPKeyPair primaryKey, PGPKeyPair subKey, PGPSignatureSubpacketVector hashedSubpackets) throws PGPException, IOException {
        int keyFlagMask = hashedSubpackets.getKeyFlags();
        if (!KeyFlag.hasKeyFlag(keyFlagMask, KeyFlag.SIGN_DATA) && !KeyFlag.hasKeyFlag(keyFlagMask, KeyFlag.CERTIFY_OTHER)) {
            return hashedSubpackets;
        }
        PGPSignatureGenerator bindingSignatureGenerator = new PGPSignatureGenerator(this.buildContentSigner(subKey));
        bindingSignatureGenerator.init(SignatureType.PRIMARYKEY_BINDING.getCode(), subKey.getPrivateKey());
        PGPSignature primaryKeyBindingSig = bindingSignatureGenerator.generateCertification(primaryKey.getPublicKey(), subKey.getPublicKey());
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator(hashedSubpackets);
        subpacketGenerator.addEmbeddedSignature(false, primaryKeyBindingSig);
        return subpacketGenerator.generate();
    }

    private PGPContentSignerBuilder buildContentSigner(PGPKeyPair certKey) {
        HashAlgorithm hashAlgorithm = PGPainless.getPolicy().getSignatureHashAlgorithmPolicy().defaultHashAlgorithm();
        return ImplementationFactory.getInstance().getPGPContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    private PBESecretKeyEncryptor buildSecretKeyEncryptor() {
        SymmetricKeyAlgorithm keyEncryptionAlgorithm = PGPainless.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy().getDefaultSymmetricKeyAlgorithm();
        PBESecretKeyEncryptor encryptor = this.passphrase == null || this.passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyEncryptor(keyEncryptionAlgorithm, this.digestCalculator, this.passphrase);
        return encryptor;
    }

    private PBESecretKeyDecryptor buildSecretKeyDecryptor() throws PGPException {
        PBESecretKeyDecryptor decryptor = this.passphrase == null || this.passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyDecryptor(this.passphrase);
        return decryptor;
    }

    private PGPDigestCalculator buildDigestCalculator() throws PGPException {
        return ImplementationFactory.getInstance().getPGPDigestCalculator(HashAlgorithm.SHA1);
    }

    public static PGPKeyPair generateKeyPair(KeySpec spec) throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
        KeyType type = spec.getKeyType();
        KeyPairGenerator certKeyGenerator = KeyPairGenerator.getInstance(type.getName(), ProviderFactory.getProvider());
        certKeyGenerator.initialize(type.getAlgorithmSpec());
        KeyPair keyPair = certKeyGenerator.generateKeyPair();
        PGPKeyPair pgpKeyPair = ImplementationFactory.getInstance().getPGPKeyPair(type.getAlgorithm(), keyPair, new Date());
        return pgpKeyPair;
    }
}

