/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification.secretkeyring;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.userid.SelectUserId;

public interface SecretKeyRingEditorInterface {
    default public SecretKeyRingEditorInterface addUserId(UserId userId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.addUserId(userId.toString(), secretKeyRingProtector);
    }

    public SecretKeyRingEditorInterface addUserId(String var1, SecretKeyRingProtector var2) throws PGPException;

    public SecretKeyRingEditorInterface deleteUserId(String var1, SecretKeyRingProtector var2);

    default public SecretKeyRingEditorInterface deleteUserId(UserId userId, SecretKeyRingProtector secretKeyRingProtector) {
        return this.deleteUserId(userId.toString(), secretKeyRingProtector);
    }

    public SecretKeyRingEditorInterface deleteUserIds(SelectUserId var1, SecretKeyRingProtector var2);

    public SecretKeyRingEditorInterface addSubKey(@Nonnull KeySpec var1, @Nonnull Passphrase var2, SecretKeyRingProtector var3) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException;

    public SecretKeyRingEditorInterface addSubKey(PGPSecretKey var1, PGPSignatureSubpacketVector var2, PGPSignatureSubpacketVector var3, SecretKeyRingProtector var4, SecretKeyRingProtector var5) throws PGPException;

    public SecretKeyRingEditorInterface deleteSubKey(OpenPgpV4Fingerprint var1, SecretKeyRingProtector var2);

    public SecretKeyRingEditorInterface deleteSubKey(long var1, SecretKeyRingProtector var3);

    default public SecretKeyRingEditorInterface revoke(SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revoke(secretKeyRingProtector, null);
    }

    public SecretKeyRingEditorInterface revoke(SecretKeyRingProtector var1, RevocationAttributes var2) throws PGPException;

    default public SecretKeyRingEditorInterface revokeSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revokeSubKey(fingerprint, secretKeyRingProtector, null);
    }

    public SecretKeyRingEditorInterface revokeSubKey(OpenPgpV4Fingerprint var1, SecretKeyRingProtector var2, RevocationAttributes var3) throws PGPException;

    default public SecretKeyRingEditorInterface revokeSubKey(long subKeyId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revokeSubKey(subKeyId, secretKeyRingProtector, null);
    }

    public SecretKeyRingEditorInterface revokeSubKey(long var1, SecretKeyRingProtector var3, RevocationAttributes var4) throws PGPException;

    default public SecretKeyRingEditorInterface revokeUserId(String userId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.revokeUserId(userId, secretKeyRingProtector, null);
    }

    public SecretKeyRingEditorInterface revokeUserId(String var1, SecretKeyRingProtector var2, RevocationAttributes var3) throws PGPException;

    public SecretKeyRingEditorInterface setExpirationDate(Date var1, SecretKeyRingProtector var2) throws PGPException;

    public SecretKeyRingEditorInterface setExpirationDate(OpenPgpV4Fingerprint var1, Date var2, SecretKeyRingProtector var3) throws PGPException;

    public PGPSignature createRevocationCertificate(SecretKeyRingProtector var1, RevocationAttributes var2) throws PGPException;

    public PGPSignature createRevocationCertificate(long var1, SecretKeyRingProtector var3, RevocationAttributes var4) throws PGPException;

    default public PGPSignature createRevocationCertificate(OpenPgpV4Fingerprint subkeyFingerprint, SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        return this.createRevocationCertificate(subkeyFingerprint.getKeyId(), secretKeyRingProtector, revocationAttributes);
    }

    default public WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase) {
        return this.changePassphraseFromOldPassphrase(oldPassphrase, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase var1, @Nonnull KeyRingProtectionSettings var2);

    default public WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase) {
        return this.changeSubKeyPassphraseFromOldPassphrase(keyId, oldPassphrase, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long var1, @Nullable Passphrase var2, @Nonnull KeyRingProtectionSettings var3);

    public PGPSecretKeyRing done();

    public static interface WithPassphrase {
        public SecretKeyRingEditorInterface toNewPassphrase(Passphrase var1) throws PGPException;

        public SecretKeyRingEditorInterface toNoPassphrase() throws PGPException;
    }

    public static interface WithKeyRingEncryptionSettings {
        public WithPassphrase withSecureDefaultSettings();

        public WithPassphrase withCustomSettings(KeyRingProtectionSettings var1);
    }
}

