/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.key.SubkeyIdentifier;

public class OnePassSignature {
    private final PGPOnePassSignature onePassSignature;
    private final PGPPublicKeyRing verificationKeys;
    private PGPSignature signature;
    private boolean verified;

    public OnePassSignature(PGPOnePassSignature onePassSignature, PGPPublicKeyRing verificationKeys) {
        this.onePassSignature = onePassSignature;
        this.verificationKeys = verificationKeys;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public PGPOnePassSignature getOnePassSignature() {
        return this.onePassSignature;
    }

    public SubkeyIdentifier getSigningKey() {
        return new SubkeyIdentifier(this.verificationKeys, this.onePassSignature.getKeyID());
    }

    public boolean verify(PGPSignature signature) throws PGPException {
        this.verified = this.getOnePassSignature().verify(signature);
        if (this.verified) {
            this.signature = signature;
        }
        return this.verified;
    }

    public PGPSignature getSignature() {
        return this.signature;
    }

    public PGPPublicKeyRing getVerificationKeys() {
        return this.verificationKeys;
    }
}

